"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAlertsPreviewEsqlQuery = void 0;
var _get_esql_keep_statement = require("./get_esql_keep_statement");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAlertsPreviewEsqlQuery = ({
  alertsIndexPattern,
  maxAlerts,
  tableStackBy0
}) => `FROM ${alertsIndexPattern} METADATA _id, _index, _version, _ignored
| WHERE kibana.alert.workflow_status IN ("open", "acknowledged") AND kibana.alert.building_block_type IS NULL
| SORT kibana.alert.risk_score DESC, @timestamp DESC
| LIMIT ${maxAlerts}
${(0, _get_esql_keep_statement.getEsqlKeepStatement)(tableStackBy0)}
`;
exports.getAlertsPreviewEsqlQuery = getAlertsPreviewEsqlQuery;