"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedPlaygroundFormProvider = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@kbn/react-query");
var _reactHookForm = require("react-hook-form");
var _common = require("../../common");
var _use_kibana = require("../hooks/use_kibana");
var _use_load_fields_by_indices = require("../hooks/use_load_fields_by_indices");
var _use_llms_models = require("../hooks/use_llms_models");
var _types = require("../types");
var _playground_form_resolver = require("../utils/playground_form_resolver");
var _saved_playgrounds = require("../utils/saved_playgrounds");
var _invalid_state_modal = require("../components/saved_playground/invalid_state_modal");
var _use_query_indices = require("../hooks/use_query_indices");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_playground/public/providers/saved_playground_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const fetchDataForValidation = async (selectedIndices, {
  client,
  http
}) => {
  let models = [];
  let indices = [];
  const indicesQuery = selectedIndices.join(',');
  [models, indices] = await Promise.all([client.fetchQuery([_common.SearchPlaygroundQueryKeys.LLMsQuery], (0, _use_llms_models.LLMsQuery)(http, client)).catch(() => []), client.fetchQuery([_common.SearchPlaygroundQueryKeys.QueryIndices, indicesQuery], (0, _use_query_indices.IndicesQuery)(http, indicesQuery, true)).catch(() => [])]);
  return {
    models,
    indices
  };
};
const fetchSavedPlayground = (playgroundId, options) => async () => {
  const {
    http,
    setLoadErrors
  } = options;
  let playgroundResp;
  try {
    playgroundResp = await http.get(_types.APIRoutes.GET_PLAYGROUND.replace('{id}', playgroundId), {
      version: _common.ROUTE_VERSIONS.v1
    });
  } catch (e) {
    return (0, _saved_playgrounds.fetchSavedPlaygroundError)(e);
  }
  const {
    models,
    indices
  } = await fetchDataForValidation(playgroundResp.data.indices, options);
  const {
    validIndices,
    missingIndices
  } = (0, _saved_playgrounds.validateSavedPlaygroundIndices)(playgroundResp.data.indices, indices);
  const missingModel = (0, _saved_playgrounds.validateSavedPlaygroundModel)(playgroundResp.data.summarizationModel, models);
  playgroundResp.data.indices = validIndices;
  if (missingModel || missingIndices.length > 0) {
    setLoadErrors({
      missingIndices,
      missingModel
    });
  }
  const result = (0, _saved_playgrounds.parseSavedPlayground)(playgroundResp, models);
  return result;
};
const SavedPlaygroundFormProvider = ({
  children,
  playgroundId
}) => {
  const [loadErrors, setLoadErrors] = (0, _react.useState)(null);
  const client = (0, _reactQuery.useQueryClient)();
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const form = (0, _reactHookForm.useForm)({
    defaultValues: fetchSavedPlayground(playgroundId, {
      http,
      client,
      setLoadErrors
    }),
    resolver: _playground_form_resolver.savedPlaygroundFormResolver,
    mode: 'onChange',
    reValidateMode: 'onChange',
    context: {
      http
    }
  });
  (0, _use_load_fields_by_indices.useLoadFieldsByIndices)({
    watch: form.watch,
    setValue: form.setValue,
    getValues: form.getValues
    // casting form handlers here because TS isn't happy with UseFormReturn<SavedPlaygroundForm> even though SavedPlaygroundForm extends PlaygroundForm
  });
  (0, _react.useEffect)(() => {
    if (form.formState.isLoading) return;
    // Trigger validation of existing values after initial loading.
    form.trigger();
  }, [form, form.formState.isLoading]);
  return /*#__PURE__*/_react.default.createElement(_reactHookForm.FormProvider, (0, _extends2.default)({}, form, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, loadErrors !== null && /*#__PURE__*/_react.default.createElement(_invalid_state_modal.SavedPlaygroundInvalidStateModal, {
    errors: loadErrors,
    onClose: () => setLoadErrors(null),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  })));
};
exports.SavedPlaygroundFormProvider = SavedPlaygroundFormProvider;