"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedPlayground = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _common = require("../../../common");
var _use_kibana = require("../../hooks/use_kibana");
var _use_load_connectors = require("../../hooks/use_load_connectors");
var _use_playground_breadcrumbs = require("../../hooks/use_playground_breadcrumbs");
var _use_saved_playground_parameters = require("../../hooks/use_saved_playground_parameters");
var _use_search_playground_feature_flag = require("../../hooks/use_search_playground_feature_flag");
var _use_show_setup_page = require("../../hooks/use_show_setup_page");
var _routes = require("../../routes");
var _types = require("../../types");
var _saved_playgrounds = require("../../utils/saved_playgrounds");
var _chat = require("../chat");
var _saved_playground_header = require("./saved_playground_header");
var _chat_setup_page = require("../setup_page/chat_setup_page");
var _search_mode = require("../search_mode/search_mode");
var _search_query_mode = require("../query_mode/search_query_mode");
var _saved_playground_fetch_error = require("./saved_playground_fetch_error");
var _edit_name_modal = require("./edit_name_modal");
var _delete_playground_modal = require("./delete_playground_modal");
var _save_playground_modal = require("./save_playground_modal");
var _search_playground_setup_page = require("../setup_page/search_playground_setup_page");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_playground/public/components/saved_playground/saved_playground.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
var SavedPlaygroundModals = /*#__PURE__*/function (SavedPlaygroundModals) {
  SavedPlaygroundModals[SavedPlaygroundModals["None"] = 0] = "None";
  SavedPlaygroundModals[SavedPlaygroundModals["EditName"] = 1] = "EditName";
  SavedPlaygroundModals[SavedPlaygroundModals["Delete"] = 2] = "Delete";
  SavedPlaygroundModals[SavedPlaygroundModals["Copy"] = 3] = "Copy";
  return SavedPlaygroundModals;
}(SavedPlaygroundModals || {});
const SavedPlayground = () => {
  const [shownModal, setShownModal] = (0, _react.useState)(SavedPlaygroundModals.None);
  const isSearchModeEnabled = (0, _use_search_playground_feature_flag.useSearchPlaygroundFeatureFlag)();
  const {
    playgroundId,
    pageMode,
    viewMode
  } = (0, _use_saved_playground_parameters.useSavedPlaygroundParameters)();
  const {
    application,
    history
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: connectors
  } = (0, _use_load_connectors.useLoadConnectors)();
  const {
    formState,
    watch
  } = (0, _reactHookForm.useFormContext)();
  const playgroundName = watch(_types.SavedPlaygroundFormFields.name);
  const playgroundIndices = watch(_types.SavedPlaygroundFormFields.indices);
  const summarizationModel = watch(_types.SavedPlaygroundFormFields.summarizationModel);
  (0, _use_playground_breadcrumbs.usePlaygroundBreadcrumbs)(playgroundName);
  const {
    showSetupPage
  } = (0, _use_show_setup_page.useShowSetupPage)({
    hasSelectedIndices: !formState.isLoading && playgroundIndices.length > 0,
    hasConnectors: Boolean(connectors === null || connectors === void 0 ? void 0 : connectors.length)
  });
  const navigateToNewPlayground = (0, _react.useCallback)((id, page, view, searchParams) => {
    let path = `/p/${id}/${page}`;
    if (view && view !== _types.PlaygroundViewMode.preview) {
      path += `/${view}`;
    }
    if (searchParams) {
      path += searchParams;
    }
    history.push(path);
  }, [history]);
  const navigateToView = (0, _react.useCallback)((id, page, view, searchParams) => {
    let path = `/p/${id}/${page}`;
    if (view && view !== _types.PlaygroundViewMode.preview) {
      path += `/${view}`;
    }
    if (searchParams) {
      path += searchParams;
    }
    application.navigateToApp(_common.PLUGIN_ID, {
      path
    });
  }, [application]);
  (0, _react.useEffect)(() => {
    if (formState.isLoading) return;
    if (pageMode === undefined) {
      // If there is not a pageMode set we default to Chat mode
      navigateToView(playgroundId, _types.PlaygroundPageMode.Chat, _types.PlaygroundViewMode.preview);
      return;
    }
    // Handle Unknown modes
    if (!Object.values(_types.PlaygroundPageMode).includes(pageMode)) {
      navigateToView(playgroundId, _types.PlaygroundPageMode.Chat, _types.PlaygroundViewMode.preview);
      return;
    }
    if (!Object.values(_types.PlaygroundViewMode).includes(viewMode)) {
      navigateToView(playgroundId, pageMode, _types.PlaygroundViewMode.preview);
    }
  }, [playgroundId, pageMode, viewMode, summarizationModel, formState.isLoading, navigateToView]);
  const {
    isDirty,
    dirtyFields
  } = formState;
  const savedFormIsDirty = (0, _react.useMemo)(() => {
    if (!isDirty) return false;
    return (0, _saved_playgrounds.isSavedPlaygroundFormDirty)(dirtyFields);
  }, [isDirty, dirtyFields]);
  const onCloseModal = (0, _react.useCallback)(() => setShownModal(SavedPlaygroundModals.None), []);
  const onDeleteSuccess = (0, _react.useCallback)(() => {
    onCloseModal();
    application.navigateToApp(_common.PLUGIN_ID);
  }, [application, onCloseModal]);
  const handleModeChange = id => navigateToView(playgroundId, pageMode !== null && pageMode !== void 0 ? pageMode : _types.PlaygroundPageMode.Search, id, location.search);
  const handlePageModeChange = mode => navigateToView(playgroundId, mode, viewMode, location.search);
  const {
    isLoading
  } = formState;
  if (isLoading || pageMode === undefined) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 11
      }
    })));
  }
  if (playgroundName.length === 0 && playgroundIndices.length === 0) {
    return /*#__PURE__*/_react.default.createElement(_saved_playground_fetch_error.SavedPlaygroundFetchError, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_saved_playground_header.SavedPlaygroundHeader, {
    playgroundName: playgroundName,
    hasChanges: savedFormIsDirty,
    pageMode: pageMode,
    viewMode: viewMode,
    onModeChange: handleModeChange,
    isActionsDisabled: false,
    onSelectPageModeChange: handlePageModeChange,
    onEditName: () => setShownModal(SavedPlaygroundModals.EditName),
    onDeletePlayground: () => setShownModal(SavedPlaygroundModals.Delete),
    onCopyPlayground: () => setShownModal(SavedPlaygroundModals.Copy),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 7
    }
  }, showSetupPage ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SAVED_PLAYGROUND_CHAT_PATH,
    component: _chat_setup_page.ChatSetupPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }), isSearchModeEnabled && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _routes.SAVED_PLAYGROUND_SEARCH_PATH,
    component: _search_playground_setup_page.SearchPlaygroundSetupPage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 15
    }
  })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SAVED_PLAYGROUND_CHAT_PATH,
    component: _chat.Chat,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SAVED_PLAYGROUND_CHAT_QUERY_PATH,
    render: () => /*#__PURE__*/_react.default.createElement(_search_query_mode.SearchQueryMode, {
      pageMode: pageMode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 29
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }), isSearchModeEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SAVED_PLAYGROUND_SEARCH_PATH,
    component: _search_mode.SearchMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.SAVED_PLAYGROUND_SEARCH_QUERY_PATH,
    render: () => /*#__PURE__*/_react.default.createElement(_search_query_mode.SearchQueryMode, {
      pageMode: pageMode,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 33
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 17
    }
  })))), shownModal === SavedPlaygroundModals.EditName && /*#__PURE__*/_react.default.createElement(_edit_name_modal.EditPlaygroundNameModal, {
    playgroundName: playgroundName,
    onClose: onCloseModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }), shownModal === SavedPlaygroundModals.Delete && /*#__PURE__*/_react.default.createElement(_delete_playground_modal.DeletePlaygroundModal, {
    playgroundId: playgroundId,
    playgroundName: playgroundName,
    onClose: onCloseModal,
    onDeleteSuccess: onDeleteSuccess,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 9
    }
  }), shownModal === SavedPlaygroundModals.Copy && /*#__PURE__*/_react.default.createElement(_save_playground_modal.SavePlaygroundModal, {
    saveAs: true,
    playgroundName: playgroundName,
    onClose: onCloseModal,
    onNavigateToNewPlayground: id => {
      navigateToNewPlayground(id, pageMode !== null && pageMode !== void 0 ? pageMode : _types.PlaygroundPageMode.Chat, viewMode, location.search);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 9
    }
  }));
};
exports.SavedPlayground = SavedPlayground;