"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlaygroundsList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("../../../common");
var _use_kibana = require("../../hooks/use_kibana");
var _use_playgrounds_list = require("../../hooks/use_playgrounds_list");
var _routes = require("../../routes");
var _playgrounds_list_error = require("./playgrounds_list_error");
var _playgrounds_list_loading = require("./playgrounds_list_loading");
var _empty_state = require("./empty_state");
var _playgrounds_table = require("./playgrounds_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_playground/public/components/playgrounds_list/playgrounds_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function PlaygroundListObjectFieldToSortField(field) {
  // SO Index does not currently allow sorting on name, update this when we update SO index settings
  switch (field) {
    case 'updatedAt':
    default:
      return 'updated_at';
  }
}
function SortFieldToPlaygroundListObjectField(sortField) {
  // SO Index does not currently allow sorting on name, update this when we update SO index settings
  switch (sortField) {
    case 'updated_at':
    default:
      return 'updatedAt';
  }
}
const PlaygroundsList = () => {
  const [playgroundQuery, setPlaygroundsQuery] = (0, _react.useState)({
    page: 1,
    sortField: 'updated_at',
    sortOrder: 'desc'
  });
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const {
    data,
    isLoading,
    isError,
    error
  } = (0, _use_playgrounds_list.usePlaygroundsList)(playgroundQuery);
  const onNewPlayground = (0, _react.useCallback)(() => {
    application.navigateToApp(_common.PLUGIN_ID, {
      path: _routes.SEARCH_PLAYGROUND_CHAT_PATH
    });
  }, [application]);
  const onTablePageChange = (0, _react.useCallback)(criteria => {
    setPlaygroundsQuery(value => {
      var _criteria$sort$direct, _criteria$sort, _criteria$sort$field, _criteria$sort2;
      return {
        page: criteria.page.index + 1,
        sortOrder: (_criteria$sort$direct = (_criteria$sort = criteria.sort) === null || _criteria$sort === void 0 ? void 0 : _criteria$sort.direction) !== null && _criteria$sort$direct !== void 0 ? _criteria$sort$direct : value.sortOrder,
        sortField: PlaygroundListObjectFieldToSortField((_criteria$sort$field = (_criteria$sort2 = criteria.sort) === null || _criteria$sort2 === void 0 ? void 0 : _criteria$sort2.field) !== null && _criteria$sort$field !== void 0 ? _criteria$sort$field : 'updatedAt')
      };
    });
  }, []);
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_playgrounds_list_loading.PlaygroundsListLoading, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 12
      }
    });
  }
  if (isError || data === undefined) {
    return /*#__PURE__*/_react.default.createElement(_playgrounds_list_error.PlaygroundsListError, {
      error: error,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 12
      }
    });
  }
  if (data._meta.total === 0) {
    return /*#__PURE__*/_react.default.createElement(_empty_state.PlaygroundsListEmptyState, {
      CTAContent: /*#__PURE__*/_react.default.createElement("span", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "newPlaygroundButton",
        fill: true,
        iconType: "plusInCircle",
        fullWidth: false,
        onClick: onNewPlayground,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.searchPlayground.playgroundsList.emptyPrompt.cta.text",
        defaultMessage: "New Playground",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 15
        }
      }))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Header, {
    pageTitle: _common.PLUGIN_NAME,
    description: _i18n.i18n.translate('xpack.searchPlayground.playgroundsList.page.description', {
      defaultMessage: 'Use your data to experiment with creating a chat experience.'
    }),
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "newPlaygroundButton",
      fill: true,
      iconType: "plusInCircle",
      onClick: onNewPlayground,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchPlayground.playgroundsList.page.cta.text",
      defaultMessage: "New Playground",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 13
      }
    }))],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    color: "plain",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_playgrounds_table.PlaygroundsTable, {
    playgroundsData: data,
    onChange: onTablePageChange,
    sortDirection: playgroundQuery.sortOrder,
    sortField: SortFieldToPlaygroundListObjectField(playgroundQuery.sortField),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 9
    }
  })));
};
exports.PlaygroundsList = PlaygroundsList;