"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIndexDocumentSearch = exports.INDEX_SEARCH_POLLING = void 0;
var _searchIndexDocuments = require("@kbn/search-index-documents");
var _reactQuery = require("@kbn/react-query");
var _use_kibana = require("../use_kibana");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_PAGINATION = {
  from: 0,
  has_more_hits_than_total: false,
  size: _constants.DEFAULT_DOCUMENT_PAGE_SIZE,
  total: 0
};
const INDEX_SEARCH_POLLING = exports.INDEX_SEARCH_POLLING = 30000;
const useIndexDocumentSearch = indexName => {
  var _data$results$_meta$p, _data$results, _data$results$_meta;
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const {
    data,
    isInitialLoading
  } = (0, _reactQuery.useQuery)({
    queryKey: [_constants.QueryKeys.SearchDocuments, indexName],
    refetchInterval: INDEX_SEARCH_POLLING,
    refetchIntervalInBackground: true,
    refetchOnWindowFocus: 'always',
    queryFn: async ({
      signal
    }) => http.post(`/internal/search_indices/${indexName}/documents/search`, {
      body: JSON.stringify({
        searchQuery: '',
        trackTotalHits: true
      }),
      query: {
        page: 0,
        size: _constants.DEFAULT_DOCUMENT_PAGE_SIZE
      },
      signal
    })
  });
  return {
    data,
    isInitialLoading,
    meta: (0, _searchIndexDocuments.pageToPagination)((_data$results$_meta$p = data === null || data === void 0 ? void 0 : (_data$results = data.results) === null || _data$results === void 0 ? void 0 : (_data$results$_meta = _data$results._meta) === null || _data$results$_meta === void 0 ? void 0 : _data$results$_meta.page) !== null && _data$results$_meta$p !== void 0 ? _data$results$_meta$p : DEFAULT_PAGINATION)
  };
};
exports.useIndexDocumentSearch = useIndexDocumentSearch;