"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetStartedWithElasticsearch = void 0;
var _searchCodeExamples = require("@kbn/search-code-examples");
var _tryInConsole = require("@kbn/try-in-console");
var _constants = require("@kbn/deeplinks-search/constants");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_kibana = require("../hooks/use_kibana");
var _sample_data_action_button = require("./sample_data_action_button");
var _use_is_sample_data_available = require("../hooks/use_is_sample_data_available");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/get_started_with_elasticsearch.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GettingStartedCards = ({
  cards,
  hoveredCard,
  onCardHover
}) => {
  const filteredCards = cards.filter(card => {
    if (card.conditionalCheck) {
      return card.conditionalCheck();
    }
    return true;
  });
  return filteredCards.map(card => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: card._id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: hoveredCard === card._id,
    display: hoveredCard === card._id ? 'plain' : 'subdued',
    onMouseEnter: () => onCardHover(card._id),
    onMouseLeave: () => onCardHover(null),
    textAlign: "left",
    titleSize: "xs",
    "data-test-subj": card.dataTestSubj,
    title: card.badgeText !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 15
      }
    }, card.title), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 19
      }
    }, card.badgeText)))) : card.title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    justifyContent: "center",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "relative",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 13
    }
  }, card.description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, card.buttonComponent)))));
};
const GetStartedWithElasticsearch = () => {
  const {
    application,
    share,
    console: consolePlugin,
    sampleDataIngest,
    chrome
  } = (0, _use_kibana.useKibana)().services;
  const [hoveredCard, setHoveredCard] = _react.default.useState(null);
  const onFileUpload = (0, _react.useCallback)(() => {
    application.navigateToApp('ml', {
      path: 'filedatavisualizer'
    });
  }, [application]);
  const onCreateIndex = (0, _react.useCallback)(() => {
    var _chrome$navLinks$get;
    const createIndexUrl = chrome === null || chrome === void 0 ? void 0 : (_chrome$navLinks$get = chrome.navLinks.get(`${_constants.SEARCH_INDICES}:${_constants.SEARCH_INDICES_CREATE_INDEX}`)) === null || _chrome$navLinks$get === void 0 ? void 0 : _chrome$navLinks$get.url;
    if (createIndexUrl) {
      application === null || application === void 0 ? void 0 : application.navigateToUrl(createIndexUrl);
    }
  }, [application, chrome]);
  const {
    hasRequiredLicense,
    isPluginAvailable: isSampleDataIngestPluginAvailable,
    hasPrivileges: hasSampleDataRequiredPrivileges
  } = (0, _use_is_sample_data_available.useIsSampleDataAvailable)();
  const isSmallScreen = (0, _eui.useIsWithinBreakpoints)(['xs', 's', 'm']);
  const gettingStartedCards = [
  // Upload file card
  {
    title: _i18n.i18n.translate('xpack.searchHomepage.connectToElasticsearch.uploadFileTitle', {
      defaultMessage: 'Upload a file'
    }),
    dataTestSubj: 'uploadFileButton',
    _id: 'uploadFileButton',
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchHomepage.connectToElasticsearch.uploadFileDescription",
      defaultMessage: "Analyze and import data from a file.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 139,
        columnNumber: 9
      }
    }),
    buttonComponent: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: onFileUpload,
      color: "text",
      size: "s",
      iconType: "export",
      "data-test-subj": "uploadFileButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.searchHomepage.connectToElasticsearch.uploadFileButton', {
      defaultMessage: 'Upload a file'
    }))
  },
  // Sample data card (conditional)
  {
    _id: 'sampleDataSection',
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchHomepage.connectToElasticsearch.sampleDatasetTitle",
      defaultMessage: "Add sample data",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 162,
        columnNumber: 9
      }
    }),
    dataTestSubj: 'sampleDataSection',
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchHomepage.connectToElasticsearch.sampleDataDescription",
      defaultMessage: "Start with pre-built data sets, including sample visualizations, dashboards, and more.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 9
      }
    }),
    buttonComponent: /*#__PURE__*/_react.default.createElement(_sample_data_action_button.SampleDataActionButton, {
      hasRequiredLicense: hasRequiredLicense,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 174,
        columnNumber: 24
      }
    }),
    conditionalCheck: () => sampleDataIngest !== undefined && isSampleDataIngestPluginAvailable && hasSampleDataRequiredPrivileges
  },
  // Create index card
  {
    _id: 'createIndexButton',
    title: _i18n.i18n.translate('xpack.searchHomepage.createIndexTitle', {
      defaultMessage: 'Create an index'
    }),
    dataTestSubj: 'gettingStartedCreateIndexButton',
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchHomepage.createIndexDescription",
      defaultMessage: "Start with a blank index and customize to match your needs.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 188,
        columnNumber: 9
      }
    }),
    buttonComponent: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: onCreateIndex,
      color: "text",
      size: "s",
      iconType: "plusInCircle",
      "data-test-subj": "createIndexButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 194,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.searchHomepage.createIndexButton', {
      defaultMessage: 'Create an index'
    }))
  },
  // Tutorial cards
  {
    _id: 'console_tutorials_search_basics',
    title: _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.basicsTitle', {
      defaultMessage: 'Search basics'
    }),
    dataTestSubj: 'console_tutorials_search_basics',
    description: _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.basicsDescription', {
      defaultMessage: 'Learn how to create an index, add documents, and basic search techniques.'
    }),
    buttonComponent: /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
      request: _searchCodeExamples.consoleTutorials.basics,
      color: "text",
      type: "button",
      application: application,
      consolePlugin: consolePlugin,
      sharePlugin: share,
      telemetryId: "console_tutorials_search_basics",
      "data-test-subj": "console_tutorials_search_basics",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 218,
        columnNumber: 9
      }
    }),
    badgeText: _i18n.i18n.translate('xpack.searchHomepage.getStarted.newBadge', {
      defaultMessage: 'NEW'
    })
  }, {
    _id: 'console_tutorials_semantic_search',
    title: _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.semanticTitle', {
      defaultMessage: 'Semantic search'
    }),
    dataTestSubj: 'console_tutorials_semantic_search',
    description: _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.semanticDescription', {
      defaultMessage: 'Learn semantic search techniques to understand intent and deliver more accurate, relevant results.'
    }),
    buttonComponent: /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
      request: _searchCodeExamples.consoleTutorials.semanticSearch,
      color: "text",
      type: "button",
      application: application,
      consolePlugin: consolePlugin,
      sharePlugin: share,
      telemetryId: "console_tutorials_semantic_search",
      "data-test-subj": "console_tutorials_semantic_search",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 9
      }
    }),
    badgeText: _i18n.i18n.translate('xpack.searchHomepage.getStarted.newBadge', {
      defaultMessage: 'NEW'
    })
  }, {
    _id: 'console_tutorials_esql',
    title: _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.esqlTitle', {
      defaultMessage: 'ES|QL'
    }),
    dataTestSubj: 'console_tutorials_esql',
    description: _i18n.i18n.translate('xpack.searchHomepage.consoleTutorials.esqlDescription', {
      defaultMessage: "Learn how to use Elastic's piped query language to simplify data investigations."
    }),
    buttonComponent: /*#__PURE__*/_react.default.createElement(_tryInConsole.TryInConsoleButton, {
      request: _searchCodeExamples.consoleTutorials.esql,
      color: "text",
      type: "button",
      application: application,
      consolePlugin: consolePlugin,
      sharePlugin: share,
      telemetryId: "console_tutorials_esql",
      "data-test-subj": "console_tutorials_esql",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 9
      }
    }),
    badgeText: _i18n.i18n.translate('xpack.searchHomepage.getStarted.newBadge', {
      defaultMessage: 'NEW'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchHomepage.getStarted.title', {
    defaultMessage: 'Get started with Elasticsearch'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 298,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 299,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.searchHomepage.getStarted.description', {
    defaultMessage: 'Use the Dev console to quickly start interacting with the Elasticsearch API.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: isSmallScreen ? 2 : 4,
    gutterSize: "l",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 308,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(GettingStartedCards, {
    cards: gettingStartedCards,
    hoveredCard: hoveredCard,
    onCardHover: setHoveredCard,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 11
    }
  }))));
};
exports.GetStartedWithElasticsearch = GetStartedWithElasticsearch;