"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsTable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _filesaver = require("@elastic/filesaver");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _lib = require("../../lib");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/objects_table/saved_objects_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// @ts-expect-error
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const unableFindSavedObjectsNotificationMessage = _i18n.i18n.translate('savedObjectsManagement.objectsTable.unableFindSavedObjectsNotificationMessage', {
  defaultMessage: 'Unable find saved objects'
});
const unableFindSavedObjectNotificationMessage = _i18n.i18n.translate('savedObjectsManagement.objectsTable.unableFindSavedObjectNotificationMessage', {
  defaultMessage: 'Unable to find saved object'
});
class SavedObjectsTable extends _react.Component {
  constructor(props) {
    var _props$initialQuery;
    super(props);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "hasCustomBrandingSubscription", void 0);
    // Ref for delete button for accessibility/focus
    (0, _defineProperty2.default)(this, "deleteButtonRef", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)(this, "fetchCounts", async () => {
      const {
        taggingApi
      } = this.props;
      const {
        queryText,
        visibleTypes,
        selectedTags
      } = (0, _lib.parseQuery)(this.state.activeQuery, this.props.allowedTypes);
      const allowedTypes = this.props.allowedTypes.map(type => type.name);
      const selectedTypes = allowedTypes.filter(type => !visibleTypes || visibleTypes.includes(type));
      const references = (0, _lib.getTagFindReferences)({
        selectedTags,
        taggingApi
      });

      // These are the saved objects visible in the table.
      const filteredSavedObjectCounts = await (0, _lib.getSavedObjectCounts)({
        http: this.props.http,
        typesToInclude: selectedTypes,
        searchString: queryText,
        references
      });
      const exportAllOptions = Object.entries(filteredSavedObjectCounts).map(([id, count]) => ({
        id,
        label: `${id} (${count || 0})`
      }));
      const exportAllSelectedOptions = exportAllOptions.reduce((record, {
        id
      }) => {
        return {
          ...record,
          [id]: true
        };
      }, {});

      // Fetch all the saved objects that exist so we can accurately populate the counts within
      // the table filter dropdown.
      const savedObjectCounts = await (0, _lib.getSavedObjectCounts)({
        http: this.props.http,
        typesToInclude: allowedTypes,
        searchString: queryText
      });
      this.setState(state => ({
        ...state,
        savedObjectCounts,
        exportAllOptions,
        exportAllSelectedOptions
      }));
    });
    (0, _defineProperty2.default)(this, "fetchAllSavedObjects", () => {
      this.setState({
        isSearching: true
      }, this.debouncedFindObjects);
    });
    (0, _defineProperty2.default)(this, "fetchSavedObjects", objects => {
      this.setState({
        isSearching: true
      }, () => this.debouncedBulkGetObjects(objects));
    });
    (0, _defineProperty2.default)(this, "debouncedFindObjects", (0, _lodash.debounce)(async () => {
      const {
        activeQuery: query,
        page,
        perPage,
        sort
      } = this.state;
      const {
        notifications,
        http,
        allowedTypes,
        taggingApi
      } = this.props;
      const {
        queryText,
        visibleTypes,
        selectedTags
      } = (0, _lib.parseQuery)(query, allowedTypes);
      const searchTypes = allowedTypes.map(type => type.name).filter(type => !visibleTypes || visibleTypes.includes(type));

      // "searchFields" is missing from the "findOptions" but gets injected via the API.
      // The API extracts the fields from each uiExports.savedObjectsManagement "defaultSearchField" attribute
      const findOptions = {
        search: queryText ? `${queryText}*` : undefined,
        perPage,
        page: page + 1,
        type: searchTypes,
        sortField: sort === null || sort === void 0 ? void 0 : sort.field,
        sortOrder: sort === null || sort === void 0 ? void 0 : sort.direction,
        hasReference: (0, _lib.getTagFindReferences)({
          selectedTags,
          taggingApi
        })
      };
      try {
        const resp = await (0, _lib.findObjects)(http, findOptions);
        if (!this._isMounted) {
          return;
        }
        this.setState(({
          activeQuery
        }) => {
          // ignore results for old requests
          if (activeQuery.text !== query.text) {
            return null;
          }
          return {
            savedObjects: resp.saved_objects,
            filteredItemCount: resp.total,
            isSearching: false
          };
        });
      } catch (error) {
        if (this._isMounted) {
          this.setState({
            isSearching: false
          });
        }
        notifications.toasts.addDanger({
          title: unableFindSavedObjectsNotificationMessage,
          text: `${error}`
        });
      }
    }, 300));
    (0, _defineProperty2.default)(this, "debouncedBulkGetObjects", (0, _lodash.debounce)(async objects => {
      const {
        notifications,
        http
      } = this.props;
      try {
        const resp = await (0, _lib.bulkGetObjects)(http, objects);
        if (!this._isMounted) {
          return;
        }
        const {
          map: fetchedObjectsMap,
          errors: objectErrors
        } = resp.reduce(({
          map,
          errors
        }, obj) => {
          if (obj.error) {
            errors.push(obj.error.message);
          } else {
            map.set(getObjectKey(obj), obj);
          }
          return {
            map,
            errors
          };
        }, {
          map: new Map(),
          errors: []
        });
        if (objectErrors.length) {
          notifications.toasts.addDanger({
            title: unableFindSavedObjectNotificationMessage,
            text: objectErrors.join(', ')
          });
        }
        this.setState(({
          savedObjects,
          filteredItemCount
        }) => {
          // modify the existing objects array, replacing any existing objects with the newly fetched ones
          const refreshedSavedObjects = savedObjects.map(obj => {
            const fetchedObject = fetchedObjectsMap.get(getObjectKey(obj));
            return fetchedObject !== null && fetchedObject !== void 0 ? fetchedObject : obj;
          });
          return {
            savedObjects: refreshedSavedObjects,
            filteredItemCount,
            isSearching: false
          };
        });
      } catch (error) {
        if (this._isMounted) {
          this.setState({
            isSearching: false
          });
        }
        notifications.toasts.addDanger({
          title: unableFindSavedObjectsNotificationMessage,
          text: `${error}`
        });
      }
    }, 300));
    (0, _defineProperty2.default)(this, "refreshAllObjects", async () => {
      await Promise.all([this.fetchAllSavedObjects(), this.fetchCounts()]);
    });
    (0, _defineProperty2.default)(this, "refreshObjects", async objects => {
      const currentObjectsSet = this.state.savedObjects.reduce((acc, obj) => acc.add(getObjectKey(obj)), new Set());
      const objectsToFetch = objects.filter(obj => currentObjectsSet.has(getObjectKey(obj)));
      if (objectsToFetch.length) {
        this.fetchSavedObjects(objectsToFetch);
      }
    });
    (0, _defineProperty2.default)(this, "onSelectionChanged", selection => {
      this.setState({
        selectedSavedObjects: selection
      }, () => {
        if (selection.length > 0 && this.deleteButtonRef.current) {
          if (this.deleteButtonRef.current && !this.deleteButtonRef.current.disabled) {
            this.deleteButtonRef.current.focus();
          }
        }
      });
    });
    (0, _defineProperty2.default)(this, "onQueryChange", ({
      query
    }) => {
      // TODO: Use isSameQuery to compare new query with state.activeQuery to avoid re-fetching the
      // same data we already have.
      this.setState({
        activeQuery: query,
        page: 0,
        // Reset this on each query change
        selectedSavedObjects: []
      }, () => {
        this.fetchAllSavedObjects();
        this.fetchCounts();
      });
    });
    (0, _defineProperty2.default)(this, "onTableChange", async table => {
      const {
        index: page,
        size: perPage
      } = table.page || {};
      this.setState({
        page,
        perPage,
        selectedSavedObjects: [],
        sort: table.sort
      }, this.fetchAllSavedObjects);
    });
    (0, _defineProperty2.default)(this, "onShowRelationships", object => {
      this.setState({
        isShowingRelationships: true,
        relationshipObject: object
      });
    });
    (0, _defineProperty2.default)(this, "onHideRelationships", () => {
      this.setState({
        isShowingRelationships: false,
        relationshipObject: undefined
      });
    });
    (0, _defineProperty2.default)(this, "onExport", async includeReferencesDeep => {
      const {
        selectedSavedObjects
      } = this.state;
      const {
        notifications,
        http
      } = this.props;
      const objectsToExport = selectedSavedObjects.map(obj => ({
        id: obj.id,
        type: obj.type
      }));
      let blob;
      try {
        blob = await (0, _lib.fetchExportObjects)(http, objectsToExport, includeReferencesDeep);
      } catch (e) {
        var _e$body$message, _e$body;
        notifications.toasts.addDanger({
          title: _i18n.i18n.translate('savedObjectsManagement.objectsTable.export.toastErrorMessage', {
            defaultMessage: 'Unable to generate export: {error}',
            values: {
              error: (_e$body$message = (_e$body = e.body) === null || _e$body === void 0 ? void 0 : _e$body.message) !== null && _e$body$message !== void 0 ? _e$body$message : e
            }
          })
        });
        throw e;
      }
      (0, _filesaver.saveAs)(blob, 'export.ndjson');
      const exportDetails = await (0, _lib.extractExportDetails)(blob);
      this.showExportCompleteMessage(exportDetails);
    });
    (0, _defineProperty2.default)(this, "onExportAll", async () => {
      const {
        exportAllSelectedOptions,
        isIncludeReferencesDeepChecked,
        activeQuery
      } = this.state;
      const {
        notifications,
        http,
        taggingApi,
        allowedTypes
      } = this.props;
      const {
        queryText,
        selectedTags
      } = (0, _lib.parseQuery)(activeQuery, allowedTypes);
      const exportTypes = Object.entries(exportAllSelectedOptions).reduce((accum, [id, selected]) => {
        if (selected) {
          accum.push(id);
        }
        return accum;
      }, []);
      const references = (0, _lib.getTagFindReferences)({
        selectedTags,
        taggingApi
      });
      let blob;
      try {
        blob = await (0, _lib.fetchExportByTypeAndSearch)({
          http,
          search: queryText ? `${queryText}*` : undefined,
          types: exportTypes,
          references,
          includeReferencesDeep: isIncludeReferencesDeepChecked
        });
      } catch (e) {
        var _e$body$message2, _e$body2;
        notifications.toasts.addDanger({
          title: _i18n.i18n.translate('savedObjectsManagement.objectsTable.export.toastErrorMessage', {
            defaultMessage: 'Unable to generate export: {error}',
            values: {
              error: (_e$body$message2 = (_e$body2 = e.body) === null || _e$body2 === void 0 ? void 0 : _e$body2.message) !== null && _e$body$message2 !== void 0 ? _e$body$message2 : e
            }
          })
        });
        throw e;
      }
      (0, _filesaver.saveAs)(blob, 'export.ndjson');
      const exportDetails = await (0, _lib.extractExportDetails)(blob);
      this.showExportCompleteMessage(exportDetails);
      this.setState({
        isShowingExportAllOptionsModal: false
      });
    });
    (0, _defineProperty2.default)(this, "showExportCompleteMessage", exportDetails => {
      const {
        notifications
      } = this.props;
      if (exportDetails) {
        if (exportDetails.missingReferences.length > 0) {
          return notifications.toasts.addWarning({
            title: _i18n.i18n.translate('savedObjectsManagement.objectsTable.export.successWithMissingRefsNotification', {
              defaultMessage: 'Your file is downloading in the background. ' + 'Some related objects could not be found. ' + 'Please see the last line in the exported file for a list of missing objects.'
            })
          });
        }
        if (exportDetails.excludedObjects.length > 0) {
          return notifications.toasts.addSuccess({
            title: _i18n.i18n.translate('savedObjectsManagement.objectsTable.export.successWithExcludedObjectsNotification', {
              defaultMessage: 'Your file is downloading in the background. ' + 'Some objects were excluded from the export. ' + 'Please see the last line in the exported file for a list of excluded objects.'
            })
          });
        }
      }
      return notifications.toasts.addSuccess({
        title: _i18n.i18n.translate('savedObjectsManagement.objectsTable.export.successNotification', {
          defaultMessage: 'Your file is downloading in the background'
        })
      });
    });
    (0, _defineProperty2.default)(this, "finishImport", () => {
      this.hideImportFlyout();
      this.fetchAllSavedObjects();
      this.fetchCounts();
    });
    (0, _defineProperty2.default)(this, "showImportFlyout", () => {
      this.setState({
        isShowingImportFlyout: true
      });
    });
    (0, _defineProperty2.default)(this, "hideImportFlyout", () => {
      this.setState({
        isShowingImportFlyout: false
      });
    });
    (0, _defineProperty2.default)(this, "onDelete", () => {
      this.setState({
        isShowingDeleteConfirmModal: true
      });
    });
    (0, _defineProperty2.default)(this, "delete", async () => {
      const {
        http,
        notifications
      } = this.props;
      const {
        selectedSavedObjects,
        isDeleting
      } = this.state;
      if (isDeleting) {
        return;
      }
      this.setState({
        isDeleting: true
      });
      const indexPatterns = selectedSavedObjects.filter(object => object.type === 'index-pattern');
      if (indexPatterns.length) {
        await this.props.dataViews.clearCache();
      }
      const deleteStatus = await (0, _lib.bulkDeleteObjects)(http, selectedSavedObjects.filter(object => !object.meta.hiddenType).map(({
        id,
        type
      }) => ({
        id,
        type
      })));
      notifications.toasts.addInfo({
        title: _i18n.i18n.translate('savedObjectsManagement.objectsTable.delete.successNotification', {
          defaultMessage: `Successfully deleted {count, plural, one {# object} other {# objects}}.`,
          values: {
            count: deleteStatus.filter(({
              success
            }) => !!success).length
          }
        })
      });

      // Unset this
      this.setState({
        selectedSavedObjects: selectedSavedObjects.filter(({
          id,
          type
        }) => deleteStatus.some((0, _lodash.matches)({
          id,
          type,
          success: false
        })))
      });

      // Fetching all data
      this.fetchAllSavedObjects();
      await this.fetchCounts();

      // Allow the user to interact with the table once the saved objects have been re-fetched.
      this.setState({
        isShowingDeleteConfirmModal: false,
        isDeleting: false
      });
    });
    (0, _defineProperty2.default)(this, "getRelationships", async (type, id) => {
      const {
        http
      } = this.props;
      const allowedTypeNames = this.props.allowedTypes.map(t => t.name);
      return await (0, _lib.getRelationships)(http, type, id, allowedTypeNames);
    });
    this.state = {
      totalCount: 0,
      page: 0,
      perPage: props.perPageConfig || 50,
      sort: {
        field: 'updated_at',
        direction: 'desc'
      },
      savedObjects: [],
      savedObjectCounts: props.allowedTypes.reduce((typeToCountMap, type) => {
        typeToCountMap[type.name] = 0;
        return typeToCountMap;
      }, {}),
      activeQuery: (_props$initialQuery = props.initialQuery) !== null && _props$initialQuery !== void 0 ? _props$initialQuery : _eui.Query.parse(''),
      selectedSavedObjects: [],
      isShowingImportFlyout: false,
      isSearching: false,
      filteredItemCount: 0,
      isShowingRelationships: false,
      relationshipObject: undefined,
      isShowingDeleteConfirmModal: false,
      isShowingExportAllOptionsModal: false,
      isDeleting: false,
      exportAllOptions: [],
      exportAllSelectedOptions: {},
      isIncludeReferencesDeepChecked: true,
      hasCustomBranding: false
    };
  }
  componentDidMount() {
    this._isMounted = true;
    this.fetchAllSavedObjects();
    this.fetchCounts();
    this.hasCustomBrandingSubscription = this.props.customBranding.hasCustomBranding$.subscribe(next => {
      this.setState({
        ...this.state,
        hasCustomBranding: next
      });
    });
  }
  componentWillUnmount() {
    var _this$hasCustomBrandi;
    this._isMounted = false;
    this.debouncedFindObjects.cancel();
    this.debouncedBulkGetObjects.cancel();
    (_this$hasCustomBrandi = this.hasCustomBrandingSubscription) === null || _this$hasCustomBrandi === void 0 ? void 0 : _this$hasCustomBrandi.unsubscribe();
  }
  renderFlyout() {
    if (!this.state.isShowingImportFlyout) {
      return null;
    }
    const {
      applications
    } = this.props;
    const newIndexPatternUrl = applications.getUrlForApp('management', {
      path: 'kibana/indexPatterns'
    });
    return /*#__PURE__*/_react.default.createElement(_components.Flyout, {
      close: this.hideImportFlyout,
      done: this.finishImport,
      http: this.props.http,
      dataViews: this.props.dataViews,
      newIndexPatternUrl: newIndexPatternUrl,
      basePath: this.props.http.basePath,
      search: this.props.search,
      allowedTypes: this.props.allowedTypes,
      showPlainSpinner: this.state.hasCustomBranding,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 594,
        columnNumber: 7
      }
    });
  }
  renderRelationships() {
    if (!this.state.isShowingRelationships) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_components.Relationships, {
      basePath: this.props.http.basePath,
      savedObject: this.state.relationshipObject,
      getRelationships: this.getRelationships,
      close: this.onHideRelationships,
      goInspectObject: this.props.goInspectObject,
      canGoInApp: this.props.canGoInApp,
      allowedTypes: this.props.allowedTypes,
      showPlainSpinner: this.state.hasCustomBranding,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 614,
        columnNumber: 7
      }
    });
  }
  renderDeleteConfirmModal() {
    const {
      isShowingDeleteConfirmModal,
      isDeleting,
      selectedSavedObjects,
      hasCustomBranding
    } = this.state;
    const {
      allowedTypes
    } = this.props;
    if (!isShowingDeleteConfirmModal) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_components.DeleteConfirmModal, {
      isDeleting: isDeleting,
      onConfirm: () => {
        this.delete();
      },
      onCancel: () => {
        this.setState({
          isShowingDeleteConfirmModal: false
        });
      },
      selectedObjects: selectedSavedObjects,
      allowedTypes: allowedTypes,
      showPlainSpinner: hasCustomBranding,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 637,
        columnNumber: 7
      }
    });
  }
  renderExportAllOptionsModal() {
    const {
      isShowingExportAllOptionsModal,
      filteredItemCount,
      exportAllOptions,
      exportAllSelectedOptions,
      isIncludeReferencesDeepChecked
    } = this.state;
    if (!isShowingExportAllOptionsModal) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_components.ExportModal, {
      onExport: this.onExportAll,
      onCancel: () => {
        this.setState({
          isShowingExportAllOptionsModal: false
        });
      },
      onSelectedOptionsChange: newOptions => {
        this.setState({
          exportAllSelectedOptions: newOptions
        });
      },
      filteredItemCount: filteredItemCount,
      options: exportAllOptions,
      selectedOptions: exportAllSelectedOptions,
      includeReferences: isIncludeReferencesDeepChecked,
      onIncludeReferenceChange: newIncludeReferences => {
        this.setState({
          isIncludeReferencesDeepChecked: newIncludeReferences
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 666,
        columnNumber: 7
      }
    });
  }
  render() {
    const {
      selectedSavedObjects,
      page,
      perPage,
      savedObjects,
      filteredItemCount,
      isSearching,
      savedObjectCounts,
      sort
    } = this.state;
    const {
      http,
      taggingApi,
      allowedTypes,
      applications
    } = this.props;
    const selectionConfig = {
      onSelectionChange: this.onSelectionChanged
    };
    const filtersWithoutTags = allowedTypes.filter(t => t.name !== 'tag');
    const itemsWithoutTags = savedObjects.filter(t => t.type !== 'tag');
    const filterOptions = filtersWithoutTags.map(type => ({
      value: type.displayName,
      name: type.displayName,
      view: `${type.displayName} (${savedObjectCounts[type.name] || 0})`
    }));
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 716,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      "aria-live": "polite",
      style: {
        position: 'absolute',
        left: '-9999px'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 718,
        columnNumber: 9
      }
    }, selectedSavedObjects.length > 0 ? _i18n.i18n.translate('savedObjectsManagement.objectsTable.selected.selectedSavedObjectsLabel', {
      defaultMessage: '{count, plural, one {# item} other {# items}} selected.',
      values: {
        count: selectedSavedObjects.length
      }
    }) : ''), this.renderFlyout(), this.renderRelationships(), this.renderDeleteConfirmModal(), this.renderExportAllOptionsModal(), /*#__PURE__*/_react.default.createElement(_components.Header, {
      onExportAll: () => this.setState({
        isShowingExportAllOptionsModal: true
      }),
      onImport: this.showImportFlyout,
      onRefresh: this.refreshAllObjects,
      filteredCount: filteredItemCount,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 735,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 741,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
      coreStart: {
        application: applications
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 742,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_components.Table, {
      basePath: http.basePath,
      taggingApi: taggingApi,
      initialQuery: this.props.initialQuery,
      allowedTypes: allowedTypes,
      itemId: item => `${item.type}:${item.id}`,
      actionRegistry: this.props.actionRegistry,
      columnRegistry: this.props.columnRegistry,
      selectionConfig: selectionConfig,
      selectedSavedObjects: selectedSavedObjects,
      onQueryChange: this.onQueryChange,
      onTableChange: this.onTableChange,
      filterOptions: filterOptions,
      onExport: this.onExport,
      capabilities: applications.capabilities,
      onDelete: this.onDelete,
      onActionRefresh: this.refreshObjects,
      goInspectObject: this.props.goInspectObject,
      pageIndex: page,
      pageSize: perPage,
      sort: sort,
      items: itemsWithoutTags,
      totalItemCount: filteredItemCount,
      isSearching: isSearching,
      onShowRelationships: this.onShowRelationships,
      canGoInApp: this.props.canGoInApp,
      deleteButtonRef: this.deleteButtonRef,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 747,
        columnNumber: 11
      }
    })));
  }
}
exports.SavedObjectsTable = SavedObjectsTable;
function getObjectKey(obj) {
  return `${obj.type}:${obj.id}`;
}