"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NotFoundErrors = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/object_view/components/not_found_errors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const savedObjectsApisLinkText = _i18n.i18n.translate('savedObjectsManagement.view.howToFixErrorDescriptionLinkText', {
  defaultMessage: 'Saved objects APIs'
});
const NotFoundErrors = ({
  type,
  docLinks
}) => {
  const getMessage = () => {
    switch (type) {
      case 'search':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjectsManagement.view.savedSearchDoesNotExistErrorMessage",
          defaultMessage: "The Discover session associated with this object no longer exists.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 33,
            columnNumber: 11
          }
        });
      case 'index-pattern':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjectsManagement.view.indexPatternDoesNotExistErrorMessage",
          defaultMessage: "The data view associated with this object no longer exists.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 40,
            columnNumber: 11
          }
        });
      case 'index-pattern-field':
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjectsManagement.view.fieldDoesNotExistErrorMessage",
          defaultMessage: "A field associated with this object no longer exists in the data view.",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 47,
            columnNumber: 11
          }
        });
      default:
        return null;
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.view.savedObjectProblemErrorMessage",
      defaultMessage: "There is a problem with this saved object",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 60,
        columnNumber: 9
      }
    }),
    iconType: "warning",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, getMessage()), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "savedObjectsManagement.view.howToFixErrorDescription",
    defaultMessage: "If you know what this error means, you can use the {savedObjectsApis} to fix it \u2014 otherwise click the delete button above.",
    values: {
      savedObjectsApis: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "aria-label": savedObjectsApisLinkText,
        href: `${docLinks.management.savedObjectsApiList}`,
        target: "_blank",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 15
        }
      }, savedObjectsApisLinkText)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  })));
};
exports.NotFoundErrors = NotFoundErrors;