"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNFunctionsView = TopNFunctionsView;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _ebtTools = require("@kbn/ebt-tools");
var _async_component = require("../../../components/async_component");
var _use_profiling_dependencies = require("../../../components/contexts/profiling_dependencies/use_profiling_dependencies");
var _topn_functions = require("../../../components/topn_functions");
var _use_profiling_params = require("../../../hooks/use_profiling_params");
var _use_profiling_router = require("../../../hooks/use_profiling_router");
var _use_time_range = require("../../../hooks/use_time_range");
var _use_time_range_async = require("../../../hooks/use_time_range_async");
var _use_async = require("../../../hooks/use_async");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/profiling/public/views/functions/topn/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function TopNFunctionsView() {
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  const {
    query
  } = (0, _use_profiling_params.useProfilingParams)('/functions/topn');
  const {
    rangeFrom,
    rangeTo,
    kuery,
    sortDirection,
    sortField,
    pageIndex = 0,
    searchFunctionName = ''
  } = query;
  const timeRange = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    services: {
      fetchTopNFunctions
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const state = (0, _use_time_range_async.useTimeRangeAsync)(({
    http
  }) => {
    return fetchTopNFunctions({
      http,
      timeFrom: new Date(timeRange.start).getTime(),
      timeTo: new Date(timeRange.end).getTime(),
      startIndex: 0,
      endIndex: 100000,
      kuery
    });
  }, [fetchTopNFunctions, timeRange.start, timeRange.end, kuery]);
  const profilingRouter = (0, _use_profiling_router.useProfilingRouter)();
  function handleOnFrameClick(value) {
    profilingRouter.push('/flamegraphs/flamegraph', {
      path: {},
      query: {
        ...query,
        searchText: value
      }
    });
  }
  function handlePageChange(nextPage) {
    profilingRouter.push('/functions/topn', {
      path: {},
      query: {
        ...query,
        pageIndex: nextPage
      }
    });
  }
  function handleSortChange(sorting) {
    profilingRouter.push('/functions/topn', {
      path: {},
      query: {
        ...query,
        sortField: sorting.id,
        sortDirection: sorting.direction
      }
    });
  }
  function handleSearchFunctionNameChange(value) {
    profilingRouter.push('/functions/topn', {
      path: {},
      query: {
        ...query,
        searchFunctionName: value
      }
    });
  }
  (0, _react.useEffect)(() => {
    if (state.status === _use_async.AsyncStatus.Settled) {
      var _state$data$TotalCoun, _state$data;
      onPageReady({
        meta: {
          rangeFrom,
          rangeTo
        },
        customMetrics: {
          key1: 'totalCount',
          value1: (_state$data$TotalCoun = (_state$data = state.data) === null || _state$data === void 0 ? void 0 : _state$data.TotalCount) !== null && _state$data$TotalCoun !== void 0 ? _state$data$TotalCoun : 0
        }
      });
    }
  }, [state.status, state.data, onPageReady, rangeFrom, rangeTo]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_async_component.AsyncComponent, (0, _extends2.default)({}, state, {
    size: "xl",
    alignTop: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_topn_functions.TopNFunctionsGrid, {
    topNFunctions: state.data,
    totalSeconds: timeRange.inSeconds.end - timeRange.inSeconds.start,
    isDifferentialView: false,
    onFrameClick: handleOnFrameClick,
    pageIndex: pageIndex,
    onChangePage: handlePageChange,
    sortField: sortField,
    sortDirection: sortDirection,
    onChangeSort: handleSortChange,
    searchFunctionName: searchFunctionName,
    onSearchFunctionNameChange: handleSearchFunctionNameChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 17
    }
  })))))));
}