"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProfilingSearchBar = ProfilingSearchBar;
var _public = require("@kbn/unified-search-plugin/public");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../../common");
var _use_profiling_dependencies = require("../contexts/profiling_dependencies/use_profiling_dependencies");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/profiling/public/components/profiling_app_page_template/profiling_search_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ProfilingSearchBar({
  kuery,
  rangeFrom,
  rangeTo,
  onQuerySubmit,
  onRefresh,
  onRefreshClick,
  showSubmitButton = true,
  dataTestSubj = 'profilingUnifiedSearchBar',
  showDatePicker = true,
  showQueryMenu = true
}) {
  const {
    start: {
      dataViews
    }
  } = (0, _use_profiling_dependencies.useProfilingDependencies)();
  const [dataView, setDataView] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    dataViews.create({
      title: _common.INDEX_EVENTS
    }).then(nextDataView => setDataView(nextDataView));
  }, [dataViews]);
  const searchBarQuery = {
    language: 'kuery',
    query: kuery
  };
  return /*#__PURE__*/_react.default.createElement(_public.SearchBar, {
    onQuerySubmit: ({
      dateRange,
      query
    }) => {
      if (dateRange.from === rangeFrom && dateRange.to === rangeTo && (query === null || query === void 0 ? void 0 : query.query) === kuery) {
        onRefreshClick();
        return;
      }
      onQuerySubmit({
        dateRange,
        query
      });
    },
    showQueryInput: true,
    showDatePicker: showDatePicker,
    showFilterBar: false,
    showSaveQuery: false,
    submitButtonStyle: !showSubmitButton ? 'iconOnly' : 'auto',
    query: searchBarQuery,
    dateRangeFrom: rangeFrom,
    dateRangeTo: rangeTo,
    indexPatterns: (0, _lodash.compact)([dataView]),
    onRefresh: onRefresh,
    displayStyle: "inPage",
    dataTestSubj: dataTestSubj,
    showQueryMenu: showQueryMenu,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  });
}