"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewPicker = DataViewPicker;
exports.default = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _calculateWidthFromCharCount = require("@kbn/calculate-width-from-char-count");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/shared/presentation_util/public/components/data_view_picker/data_view_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function DataViewPicker({
  dataViews,
  selectedDataViewId,
  onChangeDataViewId,
  trigger,
  selectableProps,
  ...other
}) {
  const [isPopoverOpen, setPopoverIsOpen] = (0, _react.useState)(false);
  const isMissingCurrent = !dataViews.some(({
    id
  }) => id === selectedDataViewId);

  // be careful to only add color with a value, otherwise it will fallbacks to "primary"
  const colorProp = isMissingCurrent ? {
    color: 'danger'
  } : {};
  const createTrigger = function () {
    const {
      label,
      title,
      ...rest
    } = trigger;
    return /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarButton, (0, _extends2.default)({
      "aria-label": title,
      "data-test-subj": "open-data-view-picker",
      onClick: () => setPopoverIsOpen(!isPopoverOpen),
      label: label,
      size: "s",
      fullWidth: true
    }, colorProp, rest, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 52,
        columnNumber: 7
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, (0, _extends2.default)({}, other, {
    ownFocus: true,
    fullWidth: true,
    display: "block",
    panelPaddingSize: "s",
    isOpen: isPopoverOpen,
    input: createTrigger(),
    closePopover: () => setPopoverIsOpen(false),
    panelMinWidth: (0, _calculateWidthFromCharCount.calculateWidthFromEntries)(dataViews, ['name', 'id']),
    panelProps: {
      'data-test-subj': 'data-view-picker-popover'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, (0, _extends2.default)({}, selectableProps, {
    searchable: true,
    singleSelection: "always",
    options: dataViews.map(({
      name,
      id,
      title
    }) => ({
      key: id,
      label: name !== null && name !== void 0 ? name : title,
      value: id,
      'data-test-subj': `data-view-picker-${name !== null && name !== void 0 ? name : title}`,
      checked: id === selectedDataViewId ? 'on' : undefined
    })),
    onChange: choices => {
      const choice = choices.find(({
        checked
      }) => checked);
      onChangeDataViewId(choice.value);
      setPopoverIsOpen(false);
    },
    searchProps: {
      compressed: true,
      ...(selectableProps ? selectableProps.searchProps : undefined)
    },
    listProps: {
      truncationProps: {
        truncation: 'middle'
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list)));
}

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
var _default = exports.default = DataViewPicker;