"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchStatus = void 0;
var _react = require("react");
var _constants = require("../../common/constants");
var _kibana = require("../common/lib/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchStatus = () => {
  const [loading, setLoading] = (0, _react.useState)(true);
  const [disabled, setDisabled] = (0, _react.useState)(false);
  const [permissionDenied, setPermissionDenied] = (0, _react.useState)(false);
  const {
    http
  } = (0, _kibana.useKibana)().services;
  (0, _react.useEffect)(() => {
    const fetchStatus = () => {
      http.get('/internal/osquery/status', {
        version: _constants.API_VERSIONS.internal.v1
      }).then(response => {
        setLoading(false);
        setDisabled((response === null || response === void 0 ? void 0 : response.install_status) !== 'installed');
      }).catch(err => {
        setLoading(false);
        if (err.body.statusCode === 403) {
          setPermissionDenied(true);
        }
      });
    };
    fetchStatus();
  }, [http]);
  return {
    loading,
    disabled,
    permissionDenied
  };
};
exports.useFetchStatus = useFetchStatus;