"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToCaseButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/cases-plugin/common");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../common/lib/kibana");
var _contexts = require("../common/contexts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/osquery/public/cases/add_to_cases_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ADD_TO_CASE = _i18n.i18n.translate('xpack.osquery.pack.queriesTable.addToCaseResultsActionAriaLabel', {
  defaultMessage: 'Add to Case'
});
const AddToCaseButton = ({
  actionId,
  agentIds = [],
  queryId = '',
  isIcon = false,
  isDisabled,
  iconProps
}) => {
  const {
    cases
  } = (0, _kibana.useKibana)().services;
  const ecsData = (0, _react.useContext)(_contexts.AlertAttachmentContext);
  const alertAttachments = (0, _react.useMemo)(() => {
    var _ecsData$_id, _ecsData$_index;
    return ecsData !== null && ecsData !== void 0 && ecsData._id ? [{
      alertId: (_ecsData$_id = ecsData === null || ecsData === void 0 ? void 0 : ecsData._id) !== null && _ecsData$_id !== void 0 ? _ecsData$_id : '',
      index: (_ecsData$_index = ecsData === null || ecsData === void 0 ? void 0 : ecsData._index) !== null && _ecsData$_index !== void 0 ? _ecsData$_index : '',
      rule: cases.helpers.getRuleIdFromEvent({
        ecs: ecsData,
        data: []
      }),
      type: _common.AttachmentType.alert
    }] : [];
  }, [cases.helpers, ecsData]);
  const casePermissions = cases.helpers.canUseCases();
  const hasCasesPermissions = casePermissions.read && casePermissions.update && casePermissions.push;
  const selectCaseModal = cases.hooks.useCasesAddToExistingCaseModal();
  const handleClick = (0, _react.useCallback)(() => {
    const attachments = [...alertAttachments, {
      type: _common.AttachmentType.externalReference,
      externalReferenceId: actionId,
      externalReferenceStorage: {
        type: _common.ExternalReferenceStorageType.elasticSearchDoc
      },
      externalReferenceAttachmentTypeId: 'osquery',
      externalReferenceMetadata: {
        actionId,
        agentIds,
        queryId
      }
    }];
    if (hasCasesPermissions) {
      selectCaseModal.open({
        getAttachments: () => attachments
      });
    }
  }, [actionId, agentIds, alertAttachments, hasCasesPermissions, queryId, selectCaseModal]);
  if (isIcon) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 28
        }
      }, ADD_TO_CASE),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, (0, _extends2.default)({
      iconType: 'casesApp',
      onClick: handleClick,
      isDisabled: isDisabled || !hasCasesPermissions,
      "aria-label": ADD_TO_CASE
    }, iconProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    iconType: "casesApp",
    onClick: handleClick,
    isDisabled: isDisabled || !hasCasesPermissions,
    "aria-label": ADD_TO_CASE,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 5
    }
  }, ADD_TO_CASE);
};
exports.AddToCaseButton = AddToCaseButton;