"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.builtinToolRegistryEntry = void 0;
var _onechatCommon = require("@kbn/onechat-common");
var _zod = require("@kbn/zod");
var _transform_built_in_form_data = require("../../../../../utils/transform_built_in_form_data");
var _zod_resolver = require("../../../../../utils/zod_resolver");
var _common = require("../common");
var _i18n = require("../../../../../utils/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// This is to support displaying form of read-only built-in tools

const builtinToolRegistryEntry = exports.builtinToolRegistryEntry = {
  label: _i18n.labels.tools.builtinLabel,
  getConfigurationComponent: () => {
    throw new Error("Built-in tools don't have a configuration component");
  },
  defaultValues: {
    ..._common.commonToolFormDefaultValues,
    type: _onechatCommon.ToolType.builtin
  },
  toolToFormData: _transform_built_in_form_data.transformBuiltInToolToFormData,
  formDataToCreatePayload: () => {
    throw new Error('Built-in tools cannot be created');
  },
  formDataToUpdatePayload: () => {
    throw new Error('Built-in tools cannot be updated');
  },
  getValidationResolver: () => (0, _zod_resolver.zodResolver)(_zod.z.any({}))
};