"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensInput = useLensInput;
var _react = require("react");
var _uuid = require("uuid");
var _visualizationUtils = require("@kbn/visualization-utils");
var _esqlUtils = require("@kbn/esql-utils");
var _fieldTypes = require("@kbn/field-types");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLensInput({
  esqlQuery,
  dataViews,
  lens,
  esqlColumns,
  preferredChartType
}) {
  const [lensInput, setLensInput] = (0, _react.useState)();
  const columns = (0, _react.useMemo)(() => esqlColumns === null || esqlColumns === void 0 ? void 0 : esqlColumns.map(c => ({
    id: c.name,
    name: c.name,
    meta: {
      type: (0, _fieldTypes.esFieldTypeToKibanaFieldType)(c.type)
    }
  })), [esqlColumns]);
  const lensHelpersAsync = (0, _useAsync.default)(() => lens.stateHelperApi(), [lens]);
  const dataViewAsync = (0, _useAsync.default)(() => (0, _esqlUtils.getESQLAdHocDataview)(esqlQuery, dataViews), [esqlQuery, dataViews]);
  const error = lensHelpersAsync.error || dataViewAsync.error;
  (0, _react.useEffect)(() => {
    if (!lensInput && lensHelpersAsync.value && dataViewAsync.value && !error) {
      const context = {
        dataViewSpec: dataViewAsync.value.toSpec(),
        fieldName: '',
        textBasedColumns: columns,
        query: {
          esql: esqlQuery
        }
      };
      const suggestions = lensHelpersAsync.value.suggestions(context, dataViewAsync.value, [], preferredChartType);
      if (suggestions !== null && suggestions !== void 0 && suggestions.length) {
        const [suggestion] = suggestions;
        const attributes = (0, _visualizationUtils.getLensAttributesFromSuggestion)({
          filters: [],
          query: {
            esql: esqlQuery
          },
          suggestion,
          dataView: dataViewAsync.value
        });
        setLensInput({
          attributes,
          id: (0, _uuid.v4)()
        });
      }
    }
  }, [lensInput, lensHelpersAsync.value, dataViewAsync.value, columns, esqlQuery, preferredChartType, error]);
  return {
    lensInput,
    setLensInput,
    isLoading: !lensInput || lensHelpersAsync.loading || dataViewAsync.loading,
    error: error || undefined
  };
}