"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentsList = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _delete_agent_context = require("../../../context/delete_agent_context");
var _use_agents = require("../../../hooks/agents/use_agents");
var _use_navigation = require("../../../hooks/use_navigation");
var _search_param_names = require("../../../search_param_names");
var _app_paths = require("../../../utils/app_paths");
var _filter_option_with_matches_badge = require("../../common/filter_option_with_matches_badge");
var _labels = require("../../common/labels");
var _agent_avatar = require("../agent_avatar");
var _use_ui_privileges = require("../../../hooks/use_ui_privileges");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/agents/list/agents_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const columnNames = {
  name: _i18n.i18n.translate('xpack.onechat.agents.nameColumn', {
    defaultMessage: 'Name'
  }),
  labels: _i18n.i18n.translate('xpack.onechat.agents.labelsColumn', {
    defaultMessage: 'Labels'
  })
};
const actionLabels = {
  chat: _i18n.i18n.translate('xpack.onechat.agents.actions.chat', {
    defaultMessage: 'Chat'
  }),
  chatDescription: _i18n.i18n.translate('xpack.onechat.agents.actions.chatDescription', {
    defaultMessage: 'Chat with agent'
  }),
  edit: _i18n.i18n.translate('xpack.onechat.agents.actions.edit', {
    defaultMessage: 'Edit'
  }),
  editDescription: _i18n.i18n.translate('xpack.onechat.agents.actions.editDescription', {
    defaultMessage: 'Edit agent'
  }),
  clone: _i18n.i18n.translate('xpack.onechat.agents.actions.clone', {
    defaultMessage: 'Clone'
  }),
  cloneDescription: _i18n.i18n.translate('xpack.onechat.agents.actions.cloneDescription', {
    defaultMessage: 'Clone agent'
  }),
  delete: _i18n.i18n.translate('xpack.onechat.agents.actions.delete', {
    defaultMessage: 'Delete'
  }),
  deleteDescription: _i18n.i18n.translate('xpack.onechat.agents.actions.deleteDescription', {
    defaultMessage: 'Delete agent'
  })
};
const AgentsList = () => {
  const {
    agents,
    isLoading,
    error
  } = (0, _use_agents.useOnechatAgents)();
  const {
    manageAgents
  } = (0, _use_ui_privileges.useUiPrivileges)();
  const {
    createOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    deleteAgent
  } = (0, _delete_agent_context.useDeleteAgent)();
  const columns = (0, _react.useMemo)(() => {
    const agentAvatar = {
      width: '48px',
      align: 'center',
      render: agent => {
        var _agent$avatar_icon;
        return agent.readonly && !agent.avatar_symbol ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: (_agent$avatar_icon = agent.avatar_icon) !== null && _agent$avatar_icon !== void 0 ? _agent$avatar_icon : 'logoElastic',
          size: "xl",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 73,
            columnNumber: 11
          }
        }) : /*#__PURE__*/_react.default.createElement(_agent_avatar.AgentAvatar, {
          agent: agent,
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 75,
            columnNumber: 11
          }
        });
      }
    };
    const agentNameAndDescription = {
      field: 'name',
      name: columnNames.name,
      render: (name, agent) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 11
        }
      }, agent.readonly ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 15
        }
      }, name) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: createOnechatUrl(_app_paths.appPaths.agents.edit({
          agentId: agent.id
        })),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 15
        }
      }, name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 13
        }
      }, agent.description)))
    };
    const agentLabels = {
      field: 'labels',
      name: columnNames.labels,
      render: labels => {
        if (!labels) {
          return null;
        }
        return /*#__PURE__*/_react.default.createElement(_labels.Labels, {
          labels: labels,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 108,
            columnNumber: 16
          }
        });
      }
    };
    const agentActions = {
      actions: [{
        type: 'icon',
        icon: 'comment',
        name: actionLabels.chat,
        description: actionLabels.chatDescription,
        isPrimary: true,
        showOnHover: true,
        href: agent => createOnechatUrl(_app_paths.appPaths.chat.new, {
          [_search_param_names.searchParamNames.agentId]: agent.id
        })
      }, {
        type: 'icon',
        icon: 'pencil',
        name: actionLabels.edit,
        description: actionLabels.editDescription,
        isPrimary: true,
        showOnHover: true,
        href: agent => createOnechatUrl(_app_paths.appPaths.agents.edit({
          agentId: agent.id
        })),
        available: agent => !agent.readonly && manageAgents
      }, {
        type: 'icon',
        icon: 'copy',
        name: actionLabels.clone,
        description: actionLabels.cloneDescription,
        showOnHover: true,
        href: agent => createOnechatUrl(_app_paths.appPaths.agents.new, {
          [_search_param_names.searchParamNames.sourceId]: agent.id
        }),
        available: () => manageAgents
      }, {
        // Have to use a custom action to display the danger color
        // Can use default action if this proposal is implemented: https://github.com/elastic/eui/discussions/8735
        render: agent => {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            position: "right",
            content: actionLabels.deleteDescription,
            delay: "long",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 149,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            direction: "row",
            alignItems: "center",
            gutterSize: "s",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 150,
              columnNumber: 17
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "trash",
            color: "danger",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 151,
              columnNumber: 19
            }
          }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            onClick: () => {
              deleteAgent({
                agent
              });
            },
            color: "danger",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 152,
              columnNumber: 19
            }
          }, actionLabels.delete)));
        },
        available: agent => !agent.readonly && manageAgents
      }]
    };
    return [agentAvatar, agentNameAndDescription, agentLabels, agentActions];
  }, [createOnechatUrl, deleteAgent, manageAgents]);
  const errorMessage = (0, _react.useMemo)(() => error ? _i18n.i18n.translate('xpack.onechat.agents.listErrorMessage', {
    defaultMessage: 'Failed to fetch agents'
  }) : undefined, [error]);
  const labelOptions = (0, _react.useMemo)(() => {
    const labels = agents.flatMap(agent => {
      var _agent$labels;
      return (_agent$labels = agent.labels) !== null && _agent$labels !== void 0 ? _agent$labels : [];
    });
    const matchesByLabel = (0, _lodash.countBy)(labels);
    const uniqueLabels = Object.keys(matchesByLabel);
    return uniqueLabels.map(label => ({
      value: label,
      view: /*#__PURE__*/_react.default.createElement(_filter_option_with_matches_badge.FilterOptionWithMatchesBadge, {
        name: label,
        matches: matchesByLabel[label],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 188,
          columnNumber: 13
        }
      })
    }));
  }, [agents]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: agents,
    itemId: agent => agent.id,
    columns: columns,
    sorting: true,
    search: {
      box: {
        incremental: true
      },
      filters: [{
        type: 'field_value_selection',
        name: 'Labels',
        multiSelect: 'and',
        options: labelOptions,
        field: 'labels',
        operator: 'exact',
        autoSortOptions: false
      }]
    },
    loading: isLoading,
    error: errorMessage,
    responsiveBreakpoint: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 5
    }
  });
};
exports.AgentsList = AgentsList;