"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentSettingsTab = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _i18n2 = require("../../../../utils/i18n");
var _use_agent_labels = require("../../../../hooks/agents/use_agent_labels");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/agents/edit/tabs/settings_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AgentSettingsTab = ({
  control,
  formState,
  isCreateMode,
  isFormDisabled
}) => {
  var _formState$errors$id, _formState$errors$con, _formState$errors$con2, _formState$errors$con3, _formState$errors$lab, _formState$errors$nam, _formState$errors$des, _formState$errors$ava, _formState$errors$ava2;
  const {
    labels: existingLabels,
    isLoading: labelsLoading
  } = (0, _use_agent_labels.useAgentLabels)();

  /* Enable shrinking; default min-width:auto blocks it and causes overflow */
  const formFlexColumnStyles = (0, _react2.css)`
    min-width: 0;
  `;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xl",
    alignItems: "flexStart",
    "aria-labelledby": "system-references-section-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "bullseye",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "system-references-section-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.systemReferencesTitle', {
    defaultMessage: 'System references'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.systemReferencesDescription', {
    defaultMessage: "Used behind the scenes to identify and guide the agent's behavior. Not shown to end users."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasBorder: false,
    hasShadow: false,
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.agentIdLabel', {
    defaultMessage: 'Agent ID'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.agentIdDescription', {
    defaultMessage: 'Unique ID to reference the agent in code or configurations.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.instructionsLabel', {
    defaultMessage: 'Instructions'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.instructionsDescription', {
    defaultMessage: 'Guides how this agent behaves when interacting with tools or responding to queries. Use this to set tone, priorities, or special behaviors.'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    css: formFlexColumnStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.onechat.agents.form.idLabel', {
      defaultMessage: 'Agent ID'
    }),
    isInvalid: !!formState.errors.id,
    error: (_formState$errors$id = formState.errors.id) === null || _formState$errors$id === void 0 ? void 0 : _formState$errors$id.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "id",
    control: control,
    render: ({
      field: {
        ref,
        ...rest
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, rest, {
      inputRef: ref,
      disabled: isFormDisabled || !isCreateMode,
      placeholder: isCreateMode ? _i18n.i18n.translate('xpack.onechat.agents.form.idPlaceholder', {
        defaultMessage: 'Enter agent ID'
      }) : '',
      isInvalid: !!formState.errors.id,
      "aria-label": _i18n.i18n.translate('xpack.onechat.agents.form.idAriaLabel', {
        defaultMessage: 'Agent ID input field'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 17
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.onechat.agents.form.customInstructionsLabel', {
      defaultMessage: 'Custom Instructions'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 15
      }
    }, _i18n2.labels.common.optional),
    isInvalid: !!((_formState$errors$con = formState.errors.configuration) !== null && _formState$errors$con !== void 0 && _formState$errors$con.instructions),
    error: (_formState$errors$con2 = formState.errors.configuration) === null || _formState$errors$con2 === void 0 ? void 0 : (_formState$errors$con3 = _formState$errors$con2.instructions) === null || _formState$errors$con3 === void 0 ? void 0 : _formState$errors$con3.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "configuration.instructions",
    control: control,
    render: ({
      field: {
        onChange,
        value
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownEditor, {
      onChange: onChange,
      value: value !== null && value !== void 0 ? value : '',
      readOnly: isFormDisabled,
      "aria-label": _i18n.i18n.translate('xpack.onechat.agents.form.customInstructionsEditorLabel', {
        defaultMessage: 'Custom Instructions Editor'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xl",
    alignItems: "flexStart",
    "aria-labelledby": "labels-section-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "tag",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "labels-section-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.labelsTitle', {
    defaultMessage: 'Labels'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.labelsDescription', {
    defaultMessage: 'Add labels to group, filter, or organize your agents.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    css: formFlexColumnStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.onechat.agents.form.labelsLabel', {
      defaultMessage: 'Labels'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 214,
        columnNumber: 15
      }
    }, _i18n2.labels.common.optional),
    isInvalid: !!formState.errors.labels,
    error: (_formState$errors$lab = formState.errors.labels) === null || _formState$errors$lab === void 0 ? void 0 : _formState$errors$lab.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "labels",
    control: control,
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      fullWidth: true,
      placeholder: _i18n.i18n.translate('xpack.onechat.agents.form.labelsPlaceholder', {
        defaultMessage: 'Add one or more labels'
      }),
      selectedOptions: (field.value || []).map(l => ({
        label: l
      })),
      options: existingLabels.map(label => ({
        label
      })),
      onCreateOption: searchValue => {
        const newLabel = searchValue.trim();
        if (!newLabel) return;
        const next = Array.from(new Set([...(field.value || []), newLabel]));
        field.onChange(next);
      },
      onChange: options => field.onChange(options.map(o => o.label)),
      isDisabled: isFormDisabled || labelsLoading,
      isClearable: true,
      isLoading: labelsLoading,
      "aria-label": _i18n.i18n.translate('xpack.onechat.agents.form.labelsAriaLabel', {
        defaultMessage: 'Agent labels selection'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 225,
        columnNumber: 17
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 221,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "xl",
    alignItems: "flexStart",
    "aria-labelledby": "presentation-section-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 260,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "brush",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "presentation-section-title",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.presentationTitle', {
    defaultMessage: 'Presentation'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.presentationDescription', {
    defaultMessage: 'Set how your agent shows up to users — choose a name, avatar, and a friendly description.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasBorder: false,
    hasShadow: false,
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.presentationNameDescriptionLabel', {
    defaultMessage: 'Display name and description'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 291,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.presentationNameDescriptionDescription', {
    defaultMessage: 'The human-friendly name and short, friendly introduction your users see when they search for and interact with this agent.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.presentationAvatarLabel', {
    defaultMessage: 'Avatar color and symbol'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 309,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.onechat.agents.form.settings.presentationAvatarDescription', {
    defaultMessage: "Customize the agent's avatar color and symbol (emoji or 2-letter code) to help visually distinguish and identify it in the UI."
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    css: formFlexColumnStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.onechat.agents.form.nameLabel', {
      defaultMessage: 'Display name'
    }),
    isInvalid: !!formState.errors.name,
    error: (_formState$errors$nam = formState.errors.name) === null || _formState$errors$nam === void 0 ? void 0 : _formState$errors$nam.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "name",
    control: control,
    render: ({
      field: {
        ref,
        ...rest
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, rest, {
      inputRef: ref,
      disabled: isFormDisabled,
      isInvalid: !!formState.errors.name,
      "aria-label": _i18n.i18n.translate('xpack.onechat.agents.form.nameAriaLabel', {
        defaultMessage: 'Agent display name input field'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 334,
        columnNumber: 17
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 330,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.onechat.agents.form.descriptionLabel', {
      defaultMessage: 'Display description'
    }),
    isInvalid: !!formState.errors.description,
    error: (_formState$errors$des = formState.errors.description) === null || _formState$errors$des === void 0 ? void 0 : _formState$errors$des.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "description",
    control: control,
    render: ({
      field: {
        ref,
        ...rest
      }
    }) => {
      var _formState$errors$con4;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, (0, _extends2.default)({}, rest, {
        inputRef: ref,
        rows: 4,
        disabled: isFormDisabled,
        isInvalid: !!((_formState$errors$con4 = formState.errors.configuration) !== null && _formState$errors$con4 !== void 0 && _formState$errors$con4.instructions),
        "aria-label": _i18n.i18n.translate('xpack.onechat.agents.form.descriptionAriaLabel', {
          defaultMessage: 'Agent display description text area'
        }),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 358,
          columnNumber: 17
        }
      }));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 354,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 375,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.onechat.agents.form.avatarColorLabel', {
      defaultMessage: 'Avatar color'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 381,
        columnNumber: 19
      }
    }, _i18n2.labels.common.optional),
    isInvalid: !!formState.errors.avatar_color,
    error: (_formState$errors$ava = formState.errors.avatar_color) === null || _formState$errors$ava === void 0 ? void 0 : _formState$errors$ava.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 376,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "avatar_color",
    control: control,
    render: ({
      field: {
        onChange,
        value
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiColorPicker, {
      onChange: onChange,
      color: value,
      disabled: isFormDisabled,
      isInvalid: !!formState.errors.avatar_color,
      "aria-label": _i18n.i18n.translate('xpack.onechat.agents.form.avatarColorAriaLabel', {
        defaultMessage: 'Agent avatar color picker'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 392,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 405,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.onechat.agents.form.avatarSymbolLabel', {
      defaultMessage: 'Avatar symbol'
    }),
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 411,
        columnNumber: 19
      }
    }, _i18n2.labels.common.optional),
    isInvalid: !!formState.errors.avatar_symbol,
    error: (_formState$errors$ava2 = formState.errors.avatar_symbol) === null || _formState$errors$ava2 === void 0 ? void 0 : _formState$errors$ava2.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 406,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "avatar_symbol",
    control: control,
    render: ({
      field: {
        ref,
        ...rest
      }
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, rest, {
      onChange: event => {
        const value = event.target.value;
        rest.onChange(value.slice(0, 2));
      },
      inputRef: ref,
      disabled: isFormDisabled,
      isInvalid: !!formState.errors.avatar_symbol,
      "aria-label": _i18n.i18n.translate('xpack.onechat.agents.form.avatarSymbolAriaLabel', {
        defaultMessage: 'Agent avatar symbol input field'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 422,
        columnNumber: 21
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 418,
      columnNumber: 17
    }
  })))))));
};
exports.AgentSettingsTab = AgentSettingsTab;