"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createObservabilityRuleTypeRegistry = createObservabilityRuleTypeRegistry;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createObservabilityRuleTypeRegistry(ruleTypeRegistry) {
  const formatters = [];
  return {
    register: type => {
      const {
        format,
        priority,
        ...rest
      } = type;
      formatters.push({
        typeId: type.id,
        priority: priority || 0,
        fn: format
      });
      ruleTypeRegistry.register(rest);
    },
    getFormatter: typeId => {
      var _formatters$find;
      return (_formatters$find = formatters.find(formatter => formatter.typeId === typeId)) === null || _formatters$find === void 0 ? void 0 : _formatters$find.fn;
    },
    list: () => formatters.sort((a, b) => b.priority - a.priority).map(formatter => formatter.typeId)
  };
}