"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createWizardContext = createWizardContext;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _nav_events = require("./nav_events");
var _path = require("./path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/context/create_wizard_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function createWizardContext({
  initialState,
  initialStep,
  steps,
  basePath
}) {
  const context = /*#__PURE__*/(0, _react.createContext)({
    setCurrentStep: () => {},
    goToStep: () => {},
    goBack: () => {},
    getState: () => initialState,
    setState: () => {},
    getPath: () => [],
    getUsage: () => ({
      timeSinceStart: 0,
      navEvents: new Array()
    })
  });
  const stepRoute = stepKey => stepKey === initialStep ? basePath : `${basePath}/${stepKey}`;
  const routes = Object.entries(steps).reduce((acc, pair) => {
    const [key, value] = pair;
    return {
      ...acc,
      [stepRoute(key)]: {
        exact: true,
        handler: () => Page({
          step: key,
          Component: value.component
        })
      }
    };
  }, {});
  function Page({
    step,
    Component
  }) {
    const {
      setCurrentStep
    } = useWizard();
    (0, _react.useEffect)(() => {
      setCurrentStep(step);
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [step]);
    return /*#__PURE__*/_react.default.createElement(Component, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 12
      }
    });
  }
  function Provider({
    children,
    onChangeStep,
    transitionDuration
  }) {
    const history = (0, _reactRouterDom.useHistory)();
    const [step, setStep] = (0, _react.useState)();
    const pathRef = (0, _react.useRef)([]);
    const usageRef = (0, _react.useRef)({
      timeSinceStart: 0,
      navEvents: new Array()
    });
    const [state, setState] = (0, _react.useState)(initialState);
    return /*#__PURE__*/_react.default.createElement(context.Provider, {
      value: {
        setCurrentStep(stepKey) {
          if (stepKey === step) {
            return;
          }
          setStep(stepKey);
          const stepVisited = pathRef.current.find(key => key === stepKey);
          pathRef.current = (0, _path.generatePath)({
            step: stepKey,
            path: pathRef.current
          });
          usageRef.current.navEvents = (0, _nav_events.generateNavEvents)({
            type: stepVisited ? 'back' : 'progress',
            step: stepKey,
            navEvents: usageRef.current.navEvents
          });
          if (onChangeStep) {
            onChangeStep({
              direction: stepVisited ? 'back' : 'next',
              stepKey,
              stepTitle: steps[stepKey].title,
              StepComponent: steps[stepKey].component
            });
          }
        },
        goToStep(stepKey) {
          if (stepKey === step) {
            return;
          }
          const stepUrl = stepRoute(stepKey);
          if (transitionDuration) {
            setTimeout(() => {
              history.push(stepUrl);
            }, transitionDuration);
          } else {
            history.push(stepUrl);
          }
        },
        goBack() {
          if (history.length === 1 || pathRef.current.length === 1 || !transitionDuration) {
            history.goBack();
          }
          setTimeout(() => {
            history.goBack();
          }, transitionDuration);
        },
        getState: () => state,
        setState: _state => {
          setState(_state);
        },
        getPath: () => [...pathRef.current],
        getUsage: () => {
          const currentTime = Date.now();
          const navEvents = usageRef.current.navEvents;
          const firstNavEvent = navEvents[0];
          const lastNavEvent = navEvents[navEvents.length - 1];
          lastNavEvent.duration = currentTime - lastNavEvent.timestamp;
          return {
            timeSinceStart: currentTime - firstNavEvent.timestamp,
            navEvents
          };
        }
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    }, children);
  }
  function useWizard() {
    return (0, _react.useContext)(context);
  }
  return {
    context,
    Provider,
    useWizard,
    routes
  };
}