"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiIntegrationInstallBanner = MultiIntegrationInstallBanner;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_install_integrations = require("../../../hooks/use_install_integrations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/observability_onboarding/public/application/quickstart_flows/otel_logs/multi_integration_install_banner.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function MultiIntegrationInstallBanner() {
  const [error, setError] = (0, _react.useState)();
  const onIntegrationCreationFailure = (0, _react.useCallback)(e => {
    setError(e);
  }, []);
  const {
    performRequest,
    requestState
  } = (0, _use_install_integrations.useInstallIntegrations)({
    onIntegrationCreationFailure,
    packages: ['system_otel', 'kubernetes_otel']
  });
  (0, _react.useEffect)(() => {
    performRequest();
  }, [performRequest]);
  const hasFailedInstallingIntegration = requestState.state === 'rejected';
  if (hasFailedInstallingIntegration) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelLogs.status.failed', {
        defaultMessage: 'Integration installation failed'
      }),
      color: "warning",
      iconType: "warning",
      "data-test-subj": "obltOnboardingOtelLogsIntegrationInstallationFailed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.observability_onboarding.otelLogs.status.failedDetails', {
      defaultMessage: 'Incoming data might not be indexed correctly. Details:'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 13
      }
    }, error === null || error === void 0 ? void 0 : error.message))));
  }
  return null;
}