"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../common/constants");
var _page_template = require("../page_template");
var _global_state_context = require("../../contexts/global_state_context");
var _overview = require("../../../components/cluster/overview");
var _external_config_context = require("../../contexts/external_config_context");
var _setup_mode = require("../../../components/renderers/setup_mode");
var _setup_mode_context = require("../../../components/setup_mode/setup_mode_context");
var _use_breadcrumbs = require("../../hooks/use_breadcrumbs");
var _fetch_clusters = require("../../../lib/fetch_clusters");
var _fetch_alerts = require("../../../lib/fetch_alerts");
var _enable_alerts_modal = require("../../../alerts/enable_alerts_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/private/monitoring/public/application/pages/cluster/overview_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CODE_PATHS = [_constants.CODE_PATH_ALL];
const ClusterOverview = () => {
  var _services$data2;
  const state = (0, _react.useContext)(_global_state_context.GlobalStateContext);
  const externalConfig = (0, _react.useContext)(_external_config_context.ExternalConfigContext);
  const {
    services
  } = (0, _public.useKibana)();
  const clusterUuid = state.cluster_uuid;
  const ccs = state.ccs;
  const [clusters, setClusters] = (0, _react.useState)([]);
  const [alerts, setAlerts] = (0, _react.useState)({});
  const [loaded, setLoaded] = (0, _react.useState)(false);
  const {
    generate: generateBreadcrumbs
  } = (0, _use_breadcrumbs.useBreadcrumbContainerContext)();
  let tabs = [];
  const title = _i18n.i18n.translate('xpack.monitoring.cluster.overviewTitle', {
    defaultMessage: 'Overview'
  });
  const pageTitle = _i18n.i18n.translate('xpack.monitoring.cluster.overview.pageTitle', {
    defaultMessage: 'Cluster overview'
  });
  if (loaded) {
    tabs = [{
      id: 'clusterName',
      label: clusters[0].cluster_name,
      testSubj: 'overviewTabsclusterName',
      route: '/overview'
    }];
  }
  const getPageData = (0, _react.useCallback)(async () => {
    var _services$data, _services$http;
    const bounds = (_services$data = services.data) === null || _services$data === void 0 ? void 0 : _services$data.query.timefilter.timefilter.getBounds();
    if ((_services$http = services.http) !== null && _services$http !== void 0 && _services$http.fetch && clusterUuid) {
      const response = await (0, _fetch_clusters.fetchClusters)({
        fetch: services.http.fetch,
        timeRange: {
          min: bounds.min.toISOString(),
          max: bounds.max.toISOString()
        },
        ccs,
        clusterUuid,
        codePaths: CODE_PATHS
      });
      setClusters(response);
      const alertsResponse = await (0, _fetch_alerts.fetchAlerts)({
        fetch: services.http.fetch,
        clusterUuid,
        timeRange: {
          min: bounds.min.valueOf(),
          max: bounds.max.valueOf()
        }
      });
      setAlerts(alertsResponse);
      setLoaded(true);
    }
  }, [ccs, clusterUuid, (_services$data2 = services.data) === null || _services$data2 === void 0 ? void 0 : _services$data2.query.timefilter.timefilter, services.http]);
  (0, _react.useEffect)(() => {
    if (clusters && clusters.length) {
      generateBreadcrumbs(clusters[0].cluster_name);
    }
  }, [clusters, generateBreadcrumbs]);
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, {
    title: title,
    pageTitle: pageTitle,
    tabs: tabs,
    getPageData: getPageData,
    showAutoOpsPromotion: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_setup_mode.SetupModeRenderer, {
    render: ({
      setupMode,
      flyoutComponent,
      bottomBarComponent
    }) => /*#__PURE__*/_react.default.createElement(_setup_mode_context.SetupModeContext.Provider, {
      value: {
        setupModeSupported: true
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 11
      }
    }, flyoutComponent, /*#__PURE__*/_react.default.createElement(_overview.Overview, {
      cluster: clusters[0],
      alerts: alerts,
      setupMode: setupMode,
      showLicenseExpiration: externalConfig.showLicenseExpiration,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 13
      }
    }), bottomBarComponent),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_enable_alerts_modal.EnableAlertsModal, {
    alerts: alerts,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }));
};
exports.ClusterOverview = ClusterOverview;