"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultSimpleQuery = void 0;
exports.isSimpleDefaultQuery = isSimpleDefaultQuery;
exports.isSimpleQuery = isSimpleQuery;
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Default instance of `SimpleQuery` with a wildcard query string.
 */
const defaultSimpleQuery = exports.defaultSimpleQuery = {
  query_string: {
    query: '*'
  }
};

/**
 * Type guard verifying if an argument is a `SimpleQuery`.
 * @param {unknown} arg - Argument to check.
 * @returns {boolean} True if `arg` is a `SimpleQuery`, false otherwise.
 */
function isSimpleQuery(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['query_string']);
}

/**
 * Type guard verifying if an argument is a `SimpleQuery` with a default query.
 * @param {unknown} arg - Argument to check.
 * @returns {boolean} True if `arg` is a `SimpleQuery`, false otherwise.
 */
function isSimpleDefaultQuery(arg) {
  return isSimpleQuery(arg) && arg.query_string.query === '*';
}