"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeAnomalyChartsAttachment = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _rxjs = require("rxjs");
var _react2 = require("@emotion/react");
var _i18nReact = require("@kbn/i18n-react");
var _common = require("@kbn/field-formats-plugin/common");
var _eui = require("@elastic/eui");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _lazy_anomaly_charts_container = require("../embeddables/anomaly_charts/lazy_anomaly_charts_container");
var _initialize_anomaly_charts_controls = require("../embeddables/anomaly_charts/initialize_anomaly_charts_controls");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/cases/anomaly_charts_attachments.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomalyChartsCaseAttachment = ({
  services,
  ...rawState
}) => {
  const id = (0, _react.useMemo)(() => (0, _eui.htmlIdGenerator)()(), []);
  const [coreStartServices, pluginStartServices, mlServices] = services;
  const contextServices = (0, _react.useMemo)(() => ({
    mlServices: {
      ...mlServices
    },
    ...pluginStartServices,
    ...coreStartServices
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const api = (0, _react.useMemo)(() => {
    var _initialState$filters, _initialState$query;
    const initialState = rawState !== null && rawState !== void 0 ? rawState : {};
    const filters$ = new _rxjs.BehaviorSubject((_initialState$filters = initialState.filters) !== null && _initialState$filters !== void 0 ? _initialState$filters : []);
    const query$ = new _rxjs.BehaviorSubject((_initialState$query = initialState.query) !== null && _initialState$query !== void 0 ? _initialState$query : undefined);
    const timeRange$ = new _rxjs.BehaviorSubject(initialState.timeRange);
    const chartsManager = (0, _initialize_anomaly_charts_controls.initializeAnomalyChartsControls)(initialState);
    const combined = {
      ...chartsManager.api,
      ...chartsManager.dataLoadingApi,
      parentApi: {
        filters$,
        query$,
        timeRange$
      }
    };
    return combined;
    // Initialize services upon first mount already,
    // as state management for cases
    // already handled by the initial state
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)({
      display: 'flex',
      width: '100%'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStartServices, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: contextServices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_lazy_anomaly_charts_container.LazyAnomalyChartsContainer, {
    id: `case-anomaly-charts-${id}`,
    severityThreshold: rawState.severityThreshold,
    api: api,
    services: services,
    onLoading: api.onLoading,
    onRenderComplete: api.onRenderComplete,
    onError: api.onError,
    timeRange$: api.parentApi.timeRange$,
    showFilterIcons: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 11
    }
  }))));
};
function isValidTimeRange(arg) {
  return (0, _mlIsPopulatedObject.isPopulatedObject)(arg, ['from', 'to']);
}
const initializeAnomalyChartsAttachment = exports.initializeAnomalyChartsAttachment = (0, _lodash.memoize)((fieldFormats, services) => {
  return /*#__PURE__*/_react.default.memo(props => {
    var _inputProps$query4, _inputProps$timeRange, _inputProps$timeRange2;
    const {
      persistableStateAttachmentState
    } = props;
    const dataFormatter = fieldFormats.deserialize({
      id: _common.FIELD_FORMAT_IDS.DATE
    });
    const inputProps = persistableStateAttachmentState;
    const descriptions = (0, _react.useMemo)(() => {
      var _inputProps$query, _inputProps$query2;
      const listItems = [{
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.cases.anomalyCharts.description.jobIdsLabel",
          defaultMessage: "Job IDs",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 112,
            columnNumber: 17
          }
        }),
        description: inputProps.jobIds.join(', ')
      }];
      if (isValidTimeRange(inputProps.timeRange)) {
        listItems.push({
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.cases.anomalyCharts.description.timeRangeLabel",
            defaultMessage: "Time range",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 124,
              columnNumber: 17
            }
          }),
          description: `${dataFormatter.convert(inputProps.timeRange.from)} - ${dataFormatter.convert(inputProps.timeRange.to)}`
        });
      }
      if (typeof ((_inputProps$query = inputProps.query) === null || _inputProps$query === void 0 ? void 0 : _inputProps$query.query) === 'string' && ((_inputProps$query2 = inputProps.query) === null || _inputProps$query2 === void 0 ? void 0 : _inputProps$query2.query) !== '') {
        var _inputProps$query3;
        listItems.push({
          title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.ml.cases.anomalySwimLane.description.queryLabel",
            defaultMessage: "Query",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 138,
              columnNumber: 17
            }
          }),
          description: (_inputProps$query3 = inputProps.query) === null || _inputProps$query3 === void 0 ? void 0 : _inputProps$query3.query
        });
      }
      return listItems;
      // eslint-disable-next-line react-hooks/exhaustive-deps
    }, [dataFormatter, inputProps.jobIds, (_inputProps$query4 = inputProps.query) === null || _inputProps$query4 === void 0 ? void 0 : _inputProps$query4.query, (_inputProps$timeRange = inputProps.timeRange) === null || _inputProps$timeRange === void 0 ? void 0 : _inputProps$timeRange.from, (_inputProps$timeRange2 = inputProps.timeRange) === null || _inputProps$timeRange2 === void 0 ? void 0 : _inputProps$timeRange2.to]);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      type: 'inline',
      listItems: descriptions,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(AnomalyChartsCaseAttachment, (0, _extends2.default)({
      services: services
    }, inputProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 158,
        columnNumber: 13
      }
    })));
  }, (prevProps, nextProps) => (0, _fastDeepEqual.default)(prevProps.persistableStateAttachmentState, nextProps.persistableStateAttachmentState));
});