"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionTable = exports.AnomalyDetectionListColumns = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlDateUtils = require("@kbn/ml-date-utils");
var _mlTimeBuckets = require("@kbn/ml-time-buckets");
var _actions = require("./actions");
var _job_selector_badge = require("../../../components/job_selector/job_selector_badge");
var _string_utils = require("../../../util/string_utils");
var _swimlane_container = require("../../../explorer/swimlane_container");
var _kibana = require("../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/overview/components/anomaly_detection_panel/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
let AnomalyDetectionListColumns = exports.AnomalyDetectionListColumns = /*#__PURE__*/function (AnomalyDetectionListColumns) {
  AnomalyDetectionListColumns["id"] = "id";
  AnomalyDetectionListColumns["maxAnomalyScore"] = "max_anomaly_score";
  AnomalyDetectionListColumns["overallSwimLane"] = "overallSwimLane";
  AnomalyDetectionListColumns["jobIds"] = "jobIds";
  AnomalyDetectionListColumns["latestTimestamp"] = "latest_timestamp";
  AnomalyDetectionListColumns["docsProcessed"] = "docs_processed";
  AnomalyDetectionListColumns["jobsInGroup"] = "jobs_in_group";
  return AnomalyDetectionListColumns;
}({});
const AnomalyDetectionTable = ({
  items,
  chartsService
}) => {
  const groupsList = Object.values(items);
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const [sortField, setSortField] = (0, _react.useState)(AnomalyDetectionListColumns.id);
  const [sortDirection, setSortDirection] = (0, _react.useState)('asc');
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useMlKibana)();
  const timeBuckets = (0, _mlTimeBuckets.useTimeBuckets)(uiSettings);
  const columns = [{
    field: AnomalyDetectionListColumns.id,
    name: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.tableId', {
      defaultMessage: 'Group ID'
    }),
    render: id => /*#__PURE__*/_react.default.createElement(_job_selector_badge.JobSelectorBadge, {
      id: id,
      isGroup: id !== 'ungrouped',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 58,
        columnNumber: 36
      }
    }),
    sortable: true,
    truncateText: true,
    width: '15%'
  }, {
    name: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.overallScore', {
      defaultMessage: 'Overall score'
    }),
    nameTooltip: {
      content: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.tableOverallScoreTooltip', {
        defaultMessage: 'Overall anomaly scores within selected time range'
      }),
      icon: 'question'
    },
    render: group => {
      const swimLaneData = group.overallSwimLane;
      if (!swimLaneData) return null;
      if (swimLaneData.points.length > 0 && swimLaneData.points.every(v => v.value === 0)) {
        return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.overview.anomalyDetection.noAnomaliesFoundMessage",
          defaultMessage: "No anomalies found",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 80,
            columnNumber: 13
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_swimlane_container.SwimlaneContainer, {
        timeBuckets: timeBuckets,
        swimlaneData: group.overallSwimLane,
        swimlaneType: 'overall',
        onResize: () => {},
        isLoading: false,
        id: group.id,
        showTimeline: false,
        showYAxis: false,
        showLegend: false,
        noDataWarning: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ml.overview.anomalyDetection.noResultsFoundMessage",
          defaultMessage: "No results found",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 15
          }
        }),
        chartsService: chartsService,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 11
        }
      });
    },
    width: '300px'
  }, {
    field: AnomalyDetectionListColumns.jobsInGroup,
    name: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.tableNumJobs', {
      defaultMessage: 'Jobs in group'
    }),
    sortable: true,
    truncateText: true,
    width: '10%'
  }, {
    field: AnomalyDetectionListColumns.latestTimestamp,
    name: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.tableLatestTimestamp', {
      defaultMessage: 'Latest timestamp'
    }),
    dataType: 'date',
    render: time => (0, _mlDateUtils.formatHumanReadableDateTime)(time),
    textOnly: true,
    truncateText: true,
    sortable: true,
    width: '25%'
  }, {
    field: AnomalyDetectionListColumns.docsProcessed,
    name: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.tableDocsProcessed', {
      defaultMessage: 'Docs processed'
    }),
    render: docs => (0, _string_utils.toLocaleString)(docs),
    textOnly: true,
    sortable: true,
    width: '15%'
  }, {
    name: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.tableActionLabel', {
      defaultMessage: 'Actions'
    }),
    actions: (0, _actions.useGroupActions)(),
    width: '80px',
    align: 'right'
  }];
  const onTableChange = ({
    page = {
      index: 0,
      size: 10
    },
    sort = {
      field: AnomalyDetectionListColumns.id,
      direction: 'asc'
    }
  }) => {
    const {
      index,
      size
    } = page;
    setPageIndex(index);
    setPageSize(size);
    const {
      field,
      direction
    } = sort;
    setSortField(field);
    setSortDirection(direction);
  };
  const pagination = {
    initialPageIndex: pageIndex,
    initialPageSize: pageSize,
    totalItemCount: groupsList.length,
    pageSizeOptions: [10, 20, 50],
    showPerPageOptions: true
  };
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    allowNeutralSort: false,
    className: "mlAnomalyDetectionTable",
    columns: columns,
    items: groupsList,
    itemId: AnomalyDetectionListColumns.id,
    onTableChange: onTableChange,
    pagination: pagination,
    sorting: sorting,
    "data-test-subj": "mlOverviewTableAnomalyDetection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 5
    }
  });
};
exports.AnomalyDetectionTable = AnomalyDetectionTable;