"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BucketSpan = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _bucket_span_input = require("./bucket_span_input");
var _job_creator_context = require("../../../job_creator_context");
var _description = require("./description");
var _bucket_span_estimator = require("../bucket_span_estimator");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/bucket_span/bucket_span.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const BucketSpan = ({
  setIsValid,
  hideEstimateButton = false
}) => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobCreatorUpdated,
    jobValidator,
    jobValidatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [bucketSpan, setBucketSpan] = (0, _react.useState)(jobCreator.bucketSpan);
  const [validation, setValidation] = (0, _react.useState)(jobValidator.bucketSpan);
  const [estimating, setEstimating] = (0, _react.useState)(false);
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'bucketSpan'
  });
  const errorId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'bucketSpanError'
  });
  (0, _react.useEffect)(() => {
    jobCreator.bucketSpan = bucketSpan;
    jobCreatorUpdate();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [bucketSpan]);
  (0, _react.useEffect)(() => {
    setBucketSpan(jobCreator.bucketSpan);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  (0, _react.useEffect)(() => {
    setValidation(jobValidator.bucketSpan);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobValidatorUpdated]);
  (0, _react.useEffect)(() => {
    setIsValid(estimating === false);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [estimating]);
  return /*#__PURE__*/_react.default.createElement(_description.Description, {
    validation: validation,
    titleId: titleId,
    errorId: errorId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_bucket_span_input.BucketSpanInput, {
    titleId: titleId,
    setBucketSpan: setBucketSpan
    // @ts-expect-error bucketSpan is of type `estypes.Duration`
    ,
    bucketSpan: bucketSpan,
    isInvalid: validation.valid === false,
    disabled: estimating,
    errorId: errorId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  })), hideEstimateButton === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_bucket_span_estimator.BucketSpanEstimator, {
    setEstimating: setEstimating,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }))));
};
exports.BucketSpan = BucketSpan;