"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResetQueryButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _job_creator_context = require("../../../job_creator_context");
var _new_job_utils = require("../../../../../utils/new_job_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/datafeed_step/components/reset_query/reset_query.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResetQueryButton = () => {
  const {
    jobCreator,
    jobCreatorUpdate
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const [confirmModalVisible, setConfirmModalVisible] = (0, _react.useState)(false);
  const [defaultQueryString] = (0, _react.useState)(JSON.stringify((0, _new_job_utils.getDefaultDatafeedQuery)(), null, 2));
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const closeModal = () => setConfirmModalVisible(false);
  const showModal = () => setConfirmModalVisible(true);
  function resetDatafeed() {
    jobCreator.query = (0, _new_job_utils.getDefaultDatafeedQuery)();
    jobCreatorUpdate();
    closeModal();
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, confirmModalVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedStep.resetQueryConfirm.title', {
      defaultMessage: 'Reset datafeed query'
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: closeModal,
    onConfirm: resetDatafeed,
    cancelButtonText: _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedStep.resetQueryConfirm.cancel', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedStep.resetQueryConfirm.confirm', {
      defaultMessage: 'Confirm'
    }),
    defaultFocusedButton: "confirm",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedStep.resetQueryConfirm.description",
    defaultMessage: "Set the datafeed query to be the default.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: "js",
    fontSize: "m",
    paddingSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, defaultQueryString)), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    onClick: showModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedStep.resetQueryButton",
    defaultMessage: "Reset datafeed query to default",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  })));
};
exports.ResetQueryButton = ResetQueryButton;