"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonEditorFlyout = exports.EDITOR_MODE = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/es-ui-shared-plugin/public");
var _ml_job_editor = require("../../../../../jobs_list/components/ml_job_editor");
var _validation_utils = require("../../../../../../../../common/util/validation_utils");
var _job_creator_context = require("../../job_creator_context");
var _job_creator = require("../../../../common/job_creator");
var _datafeed_preview_flyout = require("../datafeed_preview_flyout");
var _toast_notification_service = require("../../../../../../services/toast_notification_service");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/common/json_editor_flyout/json_editor_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  collapseLiteralStrings
} = _public.XJson;
let EDITOR_MODE = exports.EDITOR_MODE = /*#__PURE__*/function (EDITOR_MODE) {
  EDITOR_MODE[EDITOR_MODE["HIDDEN"] = 0] = "HIDDEN";
  EDITOR_MODE[EDITOR_MODE["READONLY"] = 1] = "READONLY";
  EDITOR_MODE[EDITOR_MODE["EDITABLE"] = 2] = "EDITABLE";
  return EDITOR_MODE;
}({});
const WARNING_CALLOUT_OFFSET = 100;
const JsonEditorFlyout = ({
  isDisabled,
  jobEditorMode,
  datafeedEditorMode
}) => {
  const {
    jobCreator,
    jobCreatorUpdate,
    jobCreatorUpdated
  } = (0, _react.useContext)(_job_creator_context.JobCreatorContext);
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const [showJsonFlyout, setShowJsonFlyout] = (0, _react.useState)(false);
  const [showChangedIndicesWarning, setShowChangedIndicesWarning] = (0, _react.useState)(false);
  const [jobConfigString, setJobConfigString] = (0, _react.useState)(jobCreator.formattedJobJson);
  const [datafeedConfigString, setDatafeedConfigString] = (0, _react.useState)(jobCreator.formattedDatafeedJson);
  const [saveable, setSaveable] = (0, _react.useState)(false);
  const [tempCombinedJob, setTempCombinedJob] = (0, _react.useState)(null);
  const [jobSchema, setJobSchema] = (0, _react.useState)();
  const [datafeedSchema, setDatafeedSchema] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    setJobConfigString(jobCreator.formattedJobJson);
    setDatafeedConfigString(jobCreator.formattedDatafeedJson);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [jobCreatorUpdated]);
  (0, _react.useEffect)(() => {
    if (showJsonFlyout === true) {
      // when the flyout opens, update the JSON
      setJobConfigString(jobCreator.formattedJobJson);
      setDatafeedConfigString(jobCreator.formattedDatafeedJson);
      setTempCombinedJob({
        ...JSON.parse(jobCreator.formattedJobJson),
        datafeed_config: JSON.parse(jobCreator.formattedDatafeedJson)
      });
      setShowChangedIndicesWarning(false);
    } else {
      setTempCombinedJob(null);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [showJsonFlyout]);
  (0, _react.useEffect)(function fetchSchemasOnMount() {
    // async import json schema
    Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/json-schemas/src/put___ml_anomaly_detectors__job_id__schema.json'))).then(result => {
      setJobSchema(result);
    });
    Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/json-schemas/src/put___ml_datafeeds__datafeed_id__schema.json'))).then(result => {
      setDatafeedSchema(result);
    });
  }, []);
  const editJsonMode = jobEditorMode === EDITOR_MODE.EDITABLE || datafeedEditorMode === EDITOR_MODE.EDITABLE;
  const readOnlyMode = jobEditorMode === EDITOR_MODE.READONLY && datafeedEditorMode === EDITOR_MODE.READONLY;
  function toggleJsonFlyout() {
    setSaveable(false);
    setShowJsonFlyout(!showJsonFlyout);
  }
  function onJobChange(json) {
    setJobConfigString(json);
    const valid = (0, _validation_utils.isValidJson)(json);
    setTempCombinedJob(valid ? {
      ...JSON.parse(json),
      datafeed_config: JSON.parse(datafeedConfigString)
    } : null);
    setSaveable(valid);
  }
  function onDatafeedChange(json) {
    setDatafeedConfigString(json);
    const jsonValue = collapseLiteralStrings(json);
    let valid = (0, _validation_utils.isValidJson)(jsonValue);
    if (valid) {
      // ensure that the user hasn't altered the indices list in the json.
      const datafeed = JSON.parse(jsonValue);
      const originalIndices = jobCreator.indices.sort();
      valid = originalIndices.length === datafeed.indices.length && originalIndices.every((value, index) => value === datafeed.indices[index]);
      setShowChangedIndicesWarning(valid === false);
      setTempCombinedJob({
        ...JSON.parse(jobConfigString),
        datafeed_config: datafeed
      });
    } else {
      setShowChangedIndicesWarning(false);
      setTempCombinedJob(null);
    }
    setSaveable(valid);
  }
  async function onSave() {
    const jobConfig = JSON.parse(jobConfigString);
    const datafeedConfig = JSON.parse(collapseLiteralStrings(datafeedConfigString));
    jobCreator.cloneFromExistingJob(jobConfig, datafeedConfig);
    if ((0, _job_creator.isAdvancedJobCreator)(jobCreator)) {
      try {
        await jobCreator.autoSetTimeRange();
      } catch (error) {
        const title = _i18n.i18n.translate('xpack.ml.newJob.wizard.jsonFlyout.autoSetJobCreatorTimeRange.error', {
          defaultMessage: `Error retrieving beginning and end times of index`
        });
        displayErrorToast(error, title);
      }
    }
    jobCreatorUpdate();
    setShowJsonFlyout(false);
  }
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(FlyoutButton, {
    onClick: toggleJsonFlyout,
    isDisabled: isDisabled,
    editJsonMode: editJsonMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }), showJsonFlyout === true && isDisabled === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => setShowJsonFlyout(false),
    hideCloseButton: true,
    size: 'l',
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 13
    }
  }, jobEditorMode !== EDITOR_MODE.HIDDEN ? /*#__PURE__*/_react.default.createElement(Contents, {
    editJson: jobEditorMode === EDITOR_MODE.EDITABLE,
    onChange: onJobChange,
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jsonFlyout.job.title', {
      defaultMessage: 'Job configuration JSON'
    }),
    value: jobConfigString,
    heightOffset: showChangedIndicesWarning ? WARNING_CALLOUT_OFFSET : 0,
    schema: jobSchema,
    flyoutTitleId: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 17
    }
  }) : null, datafeedEditorMode !== EDITOR_MODE.HIDDEN ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Contents, {
    editJson: datafeedEditorMode === EDITOR_MODE.EDITABLE,
    onChange: onDatafeedChange,
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jsonFlyout.datafeed.title', {
      defaultMessage: 'Datafeed configuration JSON'
    }),
    value: datafeedConfigString,
    heightOffset: showChangedIndicesWarning ? WARNING_CALLOUT_OFFSET : 0,
    schema: datafeedSchema,
    flyoutTitleId: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 19
    }
  }), datafeedEditorMode === EDITOR_MODE.EDITABLE && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_datafeed_preview_flyout.DatafeedPreview, {
    combinedJob: tempCombinedJob,
    heightOffset: showChangedIndicesWarning ? WARNING_CALLOUT_OFFSET : 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 23
    }
  }))) : null), showChangedIndicesWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    title: _i18n.i18n.translate('xpack.ml.newJob.wizard.jsonFlyout.indicesChange.calloutTitle', {
      defaultMessage: 'Indices have changed'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jsonFlyout.indicesChange.calloutText",
    defaultMessage: "You cannot alter the indices being used by the datafeed here. To select a different data view or saved Discover session, go to step 1 of the wizard and select the Change data view option.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 19
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: () => setShowJsonFlyout(false),
    flush: "left",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jsonFlyout.closeButton",
    defaultMessage: "Close",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 19
    }
  }))), readOnlyMode === false && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onSave,
    fill: true,
    isDisabled: saveable === false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.jsonFlyout.saveButton",
    defaultMessage: "Save",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 21
    }
  })))))));
};
exports.JsonEditorFlyout = JsonEditorFlyout;
const FlyoutButton = ({
  isDisabled,
  onClick,
  editJsonMode
}) => {
  const previewJsonTitle = _i18n.i18n.translate('xpack.ml.newJob.wizard.previewJsonButton', {
    defaultMessage: 'Preview JSON'
  });
  const editJsonTitle = _i18n.i18n.translate('xpack.ml.newJob.wizard.editJsonButton', {
    defaultMessage: 'Edit JSON'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClick,
    isDisabled: isDisabled,
    "data-test-subj": "mlJobWizardButtonPreviewJobJson",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 5
    }
  }, editJsonMode ? editJsonTitle : previewJsonTitle);
};
const Contents = ({
  title,
  flyoutTitleId,
  value,
  editJson,
  onChange,
  heightOffset = 0,
  schema
}) => {
  // the editor requires a fixed height
  const editorHeight = (0, _react.useMemo)(() => `${window.innerHeight - 230 - heightOffset}px`, [heightOffset]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 9
    }
  }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 322,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ml_job_editor.MLJobEditor, {
    value: value,
    height: editorHeight,
    mode: _ml_job_editor.ML_EDITOR_MODE.JSON,
    readOnly: editJson === false,
    onChange: onChange,
    schema: schema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 7
    }
  }));
};