"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DatafeedPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _ml_job_editor = require("../../../../../jobs_list/components/ml_job_editor");
var _kibana = require("../../../../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/common/datafeed_preview_flyout/datafeed_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DatafeedPreview = ({
  combinedJob,
  heightOffset = 0,
  flyoutTitleId
}) => {
  const {
    jobs: {
      datafeedPreview
    }
  } = (0, _kibana.useMlApi)();
  // the editor requires a fixed height
  const editorHeight = (0, _react.useMemo)(() => `${window.innerHeight - 230 - heightOffset}px`, [heightOffset]);
  const [loading, setLoading] = (0, _react.useState)(false);
  const [previewJsonString, setPreviewJsonString] = (0, _react.useState)('');
  const [outOfDate, setOutOfDate] = (0, _react.useState)(false);
  const [combinedJobString, setCombinedJobString] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    try {
      if (combinedJob !== null) {
        if (combinedJobString === '') {
          // first time, set the string and load the preview
          loadDataPreview();
        } else {
          setOutOfDate(JSON.stringify(combinedJob) !== combinedJobString);
        }
      }
    } catch (error) {
      // fail silently
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [combinedJob]);
  const loadDataPreview = (0, _react.useCallback)(async () => {
    setPreviewJsonString('');
    if (combinedJob === null) {
      return;
    }
    setLoading(true);
    setCombinedJobString(JSON.stringify(combinedJob));
    if (combinedJob.datafeed_config && combinedJob.datafeed_config.indices.length) {
      try {
        const {
          datafeed_config: datafeed,
          ...job
        } = combinedJob;
        if (job.analysis_config.detectors.length === 0) {
          setPreviewJsonString(_i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedPreviewFlyout.noDetectors', {
            defaultMessage: 'No detectors configured'
          }));
        } else {
          const preview = await datafeedPreview(undefined, job, datafeed);
          setPreviewJsonString(JSON.stringify(preview, null, 2));
        }
      } catch (error) {
        setPreviewJsonString(JSON.stringify(error, null, 2));
      }
      setLoading(false);
      setOutOfDate(false);
    } else {
      const errorText = _i18n.i18n.translate('xpack.ml.newJob.wizard.datafeedPreviewFlyout.datafeedDoesNotExistLabel', {
        defaultMessage: 'Datafeed does not exist'
      });
      setPreviewJsonString(errorText);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [combinedJob]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.datafeedPreviewFlyout.title",
    defaultMessage: "Datafeed preview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, outOfDate && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: loadDataPreview,
    iconType: "refresh",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, "Refresh"))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 7
    }
  }), loading === true ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceAround",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }))) : /*#__PURE__*/_react.default.createElement(_ml_job_editor.MLJobEditor, {
    value: previewJsonString,
    height: editorHeight,
    readOnly: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }));
};
exports.DatafeedPreview = DatafeedPreview;