"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExplorationQueryBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _mlQueryUtils = require("@kbn/ml-query-utils");
var _app = require("../../../../../../../common/constants/app");
var _explorer_utils = require("../../../../../explorer/explorer_utils");
var _kibana = require("../../../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/exploration_query_bar/exploration_query_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ExplorationQueryBar = ({
  dataView,
  setSearchQuery,
  filters,
  query
}) => {
  // The internal state of the input query bar updated on every key stroke.
  const [searchInput, setSearchInput] = (0, _react.useState)(query);
  const [idToSelectedMap, setIdToSelectedMap] = (0, _react.useState)({});
  const [queryErrorMessage, setQueryErrorMessage] = (0, _react.useState)(undefined);
  const {
    services
  } = (0, _kibana.useMlKibana)();
  const {
    unifiedSearch: {
      ui: {
        QueryStringInput
      }
    }
  } = services;
  const searchChangeHandler = q => setSearchInput(q);
  const regex = (0, _react.useMemo)(() => new RegExp(`${filters === null || filters === void 0 ? void 0 : filters.columnId}\\s*:\\s*(true|false)`, 'g'), [filters === null || filters === void 0 ? void 0 : filters.columnId]);

  /**
   * Restoring state from the URL once on load. If a filter option is active
   * in the url set the corresponding options button to selected mode.
   */
  (0, _react.useEffect)(function updateIdToSelectedMap() {
    if (filters !== undefined) {
      const match = query.query.match(regex);
      let filterKeyInEffect;
      if (match !== null && match[0].includes('true')) {
        // set { training: true }
        filterKeyInEffect = Object.keys(filters.key).find(i => filters.key[i] === true);
      } else if (match !== null && match[0].includes('false')) {
        // set { testing: true }
        filterKeyInEffect = Object.keys(filters.key).find(i => filters.key[i] === false);
      }
      if (filterKeyInEffect) {
        setIdToSelectedMap({
          [filterKeyInEffect]: true
        });
      }
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);

  /**
   * Component is responsible for parsing the query string,
   * hence it should sync submitted query string.
   */
  (0, _react.useEffect)(() => {
    try {
      let convertedQuery = {};
      switch (query.language) {
        case _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY:
          convertedQuery = (0, _esQuery.toElasticsearchQuery)((0, _esQuery.fromKueryExpression)(query.query), dataView);
          break;
        case _mlQueryUtils.SEARCH_QUERY_LANGUAGE.LUCENE:
          convertedQuery = (0, _esQuery.luceneStringToDsl)(query.query);
          break;
        default:
          setQueryErrorMessage({
            query: query.query,
            message: _i18n.i18n.translate('xpack.ml.queryBar.queryLanguageNotSupported', {
              defaultMessage: 'Query language is not supported'
            })
          });
          return;
      }
      setSearchQuery({
        queryString: query.query,
        query: convertedQuery,
        language: query.language
      });
    } catch (e) {
      setQueryErrorMessage({
        query: query.query,
        message: e.message
      });
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [query.query]);
  const searchSubmitHandler = (q, filtering) => {
    // If moved to querying manually, clear filter selection.
    if (filtering === undefined) {
      setIdToSelectedMap({});
    }
    setSearchQuery({
      queryString: q.query,
      language: q.language
    });
  };
  const debouncedHandleFilterUpdate = (0, _lodash.debounce)((optionId, currentIdToSelectedMap) => {
    let newQuery = '';
    const filterValue = filters === null || filters === void 0 ? void 0 : filters.key[optionId];
    const filterQueryString = `${filters === null || filters === void 0 ? void 0 : filters.columnId}:${filterValue}`;

    // Toggling selected optionId to 'off' - remove column id query from filter
    if (currentIdToSelectedMap[optionId] === false) {
      newQuery = searchInput.query !== '' ? (0, _explorer_utils.removeFilterFromQueryString)(searchInput.query, filters === null || filters === void 0 ? void 0 : filters.columnId, String(filterValue)) : '';
    } else if (currentIdToSelectedMap[optionId] === true) {
      // Toggling selected optionId to 'on'
      if (searchInput.query === '') {
        newQuery = filterQueryString;
      } else if (searchInput.query.match(regex) !== null) {
        // If query already contains columnId filter - replace with incoming value from filter selection
        newQuery = searchInput.query.replace(regex, filterQueryString);
      } else {
        // Otherwise just add filter query to the end of existing query
        newQuery = `${searchInput.query} and ${filterQueryString}`;
      }
    }
    // Add the filter query to the search input and setSearchQuery
    const newSearchInput = {
      ...searchInput,
      query: newQuery
    };
    setSearchInput(newSearchInput);
    searchSubmitHandler(newSearchInput, true);
  }, 200);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInputPopover, {
    style: {
      maxWidth: '100%'
    },
    closePopover: () => setQueryErrorMessage(undefined),
    input: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 181,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(QueryStringInput, {
      bubbleSubmitEvent: false,
      query: searchInput,
      indexPatterns: [dataView],
      onChange: searchChangeHandler,
      onSubmit: searchSubmitHandler,
      placeholder: searchInput.language === _mlQueryUtils.SEARCH_QUERY_LANGUAGE.KUERY ? _i18n.i18n.translate('xpack.ml.stepDefineForm.queryPlaceholderKql', {
        defaultMessage: 'Search for e.g. {example}',
        values: {
          example: 'method : "GET" or status : "404"'
        }
      }) : _i18n.i18n.translate('xpack.ml.stepDefineForm.queryPlaceholderLucene', {
        defaultMessage: 'Search for e.g. {example}',
        values: {
          example: 'method:GET OR status:404'
        }
      }),
      disableAutoFocus: true,
      dataTestSubj: "mlDFAnalyticsQueryInput",
      languageSwitcherPopoverAnchorPosition: "rightDown",
      appName: _app.PLUGIN_ID,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 13
      }
    })), filters && filters.options && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      "data-test-subj": "mlDFAnalyticsExplorationQueryBarFilterButtons",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
      legend: _i18n.i18n.translate('xpack.ml.dataframe.analytics.explorationQueryBar.buttonGroupLegend', {
        defaultMessage: 'Analytics query bar filter buttons'
      }),
      options: filters.options,
      type: "multi",
      idToSelectedMap: idToSelectedMap,
      onChange: optionId => {
        const newIdToSelectedMap = {
          [optionId]: !idToSelectedMap[optionId]
        };
        setIdToSelectedMap(newIdToSelectedMap);
        debouncedHandleFilterUpdate(optionId, newIdToSelectedMap);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 15
      }
    }))),
    isOpen: (queryErrorMessage === null || queryErrorMessage === void 0 ? void 0 : queryErrorMessage.query) === searchInput.query && (queryErrorMessage === null || queryErrorMessage === void 0 ? void 0 : queryErrorMessage.message) !== '',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.ml.stepDefineForm.invalidQuery', {
    defaultMessage: 'Invalid Query'
  }), ': ', queryErrorMessage === null || queryErrorMessage === void 0 ? void 0 : queryErrorMessage.message.split('\n')[0]));
};
exports.ExplorationQueryBar = ExplorationQueryBar;