"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobType = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/configuration_step/job_type.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const jobDetails = {
  [_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.OUTLIER_DETECTION]: {
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.outlierDetectionHelpText', {
      defaultMessage: 'Identify unusual data points in the data set.'
    }),
    icon: 'outlierDetectionJob',
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.outlierDetectionTitle', {
      defaultMessage: 'Outlier detection'
    })
  },
  [_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.REGRESSION]: {
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.regressionHelpText', {
      defaultMessage: 'Predict numerical values in the data set.'
    }),
    icon: 'regressionJob',
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.regressionTitle', {
      defaultMessage: 'Regression'
    })
  },
  [_mlDataFrameAnalyticsUtils.ANALYSIS_CONFIG_TYPE.CLASSIFICATION]: {
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.classificationHelpText', {
      defaultMessage: 'Predict classes of data points in the data set.'
    }),
    icon: 'classificationJob',
    title: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.classificationTitle', {
      defaultMessage: 'Classification'
    })
  }
};
const JobType = ({
  type,
  setFormState
}) => {
  const [selectedCard, setSelectedCard] = (0, _react.useState)({});
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    "data-test-subj": "mlAnalyticsCreateJobWizardJobTypeSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, Object.keys(jobDetails).map(jobType => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: jobType,
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: jobDetails[jobType].icon,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 21
      }
    }),
    title: jobDetails[jobType].title,
    description: jobDetails[jobType].helpText,
    "data-test-subj": `mlAnalyticsCreation-${jobType}-option${type === jobType ? ' selectedJobType' : ''}`,
    selectable: {
      onClick: () => {
        // Only allow one job selected at a time and don't allow deselection
        if (selectedCard[jobType] === true) {
          return;
        }
        setFormState({
          previousJobType: type,
          jobType,
          requiredFieldsError: undefined
        });
        setSelectedCard({
          [jobType]: !selectedCard[jobType]
        });
      },
      isSelected: selectedCard[jobType] === true || type === jobType
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }));
};
exports.JobType = JobType;