"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddInferencePipelineFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _constants = require("./constants");
var _shared = require("../shared");
var _state = require("./state");
var _pipeline_details = require("./components/pipeline_details");
var _processor_configuration = require("./components/processor_configuration");
var _test_pipeline = require("./components/test_pipeline");
var _kibana = require("../../contexts/kibana");
var _get_pipeline_config = require("./get_pipeline_config");
var _validation = require("./validation");
var _types = require("./types");
var _use_fetch_pipelines = require("./hooks/use_fetch_pipelines");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/components/ml_inference/add_inference_pipeline_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AddInferencePipelineFlyout = ({
  onClose,
  model
}) => {
  var _model$input;
  // eslint-disable-next-line react-hooks/exhaustive-deps
  const initialState = (0, _react.useMemo)(() => (0, _state.getInitialState)(model), [model.model_id]);
  const [formState, setFormState] = (0, _react.useState)(initialState);
  const [step, setStep] = (0, _react.useState)(_constants.ADD_INFERENCE_PIPELINE_STEPS.DETAILS);
  const [hasUnsavedChanges, setHasUnsavedChanges] = (0, _react.useState)(false);
  const {
    trainedModels: {
      createInferencePipeline
    }
  } = (0, _kibana.useMlApi)();
  const modelType = (0, _state.getModelType)(model);
  const createPipeline = async () => {
    setFormState({
      ...formState,
      creatingPipeline: true
    });
    try {
      await createInferencePipeline(formState.pipelineName, (0, _get_pipeline_config.getPipelineConfig)(formState));
      setFormState({
        ...formState,
        pipelineCreated: true,
        creatingPipeline: false,
        pipelineError: undefined
      });
    } catch (e) {
      var _errorProperties$mess;
      // eslint-disable-next-line no-console
      console.error(e);
      const errorProperties = (0, _mlErrorUtils.extractErrorProperties)(e);
      setFormState({
        ...formState,
        creatingPipeline: false,
        pipelineError: (_errorProperties$mess = errorProperties.message) !== null && _errorProperties$mess !== void 0 ? _errorProperties$mess : e.message
      });
    }
  };
  const pipelineNames = (0, _use_fetch_pipelines.useFetchPipelines)();
  const handleConfigUpdate = configUpdate => {
    setFormState({
      ...formState,
      ...configUpdate
    });
  };
  const {
    pipelineName: pipelineNameError,
    targetField: targetFieldError
  } = (0, _react.useMemo)(() => {
    const errors = (0, _validation.validateInferencePipelineConfigurationStep)(formState.pipelineName, pipelineNames);
    return errors;
  }, [pipelineNames, formState.pipelineName]);
  const sourceIndex = (0, _react.useMemo)(() => {
    var _model$metadata, _model$metadata2, _model$metadata3;
    return Array.isArray((_model$metadata = model.metadata) === null || _model$metadata === void 0 ? void 0 : _model$metadata.analytics_config.source.index) ? (_model$metadata2 = model.metadata) === null || _model$metadata2 === void 0 ? void 0 : _model$metadata2.analytics_config.source.index.join() : (_model$metadata3 = model.metadata) === null || _model$metadata3 === void 0 ? void 0 : _model$metadata3.analytics_config.source.index;
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [model === null || model === void 0 ? void 0 : model.model_id]);
  const titleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'mlInferencePipelineFlyoutTitle'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "l",
    "data-test-subj": "mlTrainedModelsInferencePipelineFlyout",
    includeFixedHeadersInFocusTrap: false,
    "aria-labelledby": titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    id: titleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.title', {
    defaultMessage: 'Deploy analytics model'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.AddInferencePipelineHorizontalSteps, {
    step: step,
    setStep: setStep,
    isDetailsStepValid: pipelineNameError === undefined && targetFieldError === undefined,
    isConfigureProcessorStepValid: hasUnsavedChanges === false,
    hasProcessorStep: true,
    pipelineCreated: formState.pipelineCreated,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }), step === _constants.ADD_INFERENCE_PIPELINE_STEPS.DETAILS && /*#__PURE__*/_react.default.createElement(_pipeline_details.PipelineDetails, {
    handlePipelineConfigUpdate: handleConfigUpdate,
    pipelineName: formState.pipelineName,
    pipelineNameError: pipelineNameError,
    pipelineDescription: formState.pipelineDescription,
    modelId: model.model_id,
    targetField: formState.targetField,
    targetFieldError: targetFieldError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 11
    }
  }), step === _constants.ADD_INFERENCE_PIPELINE_STEPS.CONFIGURE_PROCESSOR && model && /*#__PURE__*/_react.default.createElement(_processor_configuration.ProcessorConfiguration, {
    condition: formState.condition,
    fieldMap: formState.fieldMap,
    handleAdvancedConfigUpdate: handleConfigUpdate,
    inferenceConfig: formState.inferenceConfig,
    modelInferenceConfig: model.inference_config,
    modelInputFields: (_model$input = model.input) !== null && _model$input !== void 0 ? _model$input : [],
    modelType: modelType,
    setHasUnsavedChanges: setHasUnsavedChanges,
    tag: formState.tag,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 11
    }
  }), step === _constants.ADD_INFERENCE_PIPELINE_STEPS.ON_FAILURE && /*#__PURE__*/_react.default.createElement(_shared.OnFailureConfiguration, {
    ignoreFailure: formState.ignoreFailure,
    takeActionOnFailure: formState.takeActionOnFailure,
    handleAdvancedConfigUpdate: handleConfigUpdate,
    onFailure: formState.onFailure,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }), step === _constants.ADD_INFERENCE_PIPELINE_STEPS.TEST && /*#__PURE__*/_react.default.createElement(_test_pipeline.TestPipeline, {
    sourceIndex: sourceIndex,
    state: formState,
    mode: _types.TEST_PIPELINE_MODE.STEP,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }), step === _constants.ADD_INFERENCE_PIPELINE_STEPS.CREATE && /*#__PURE__*/_react.default.createElement(_shared.ReviewAndCreatePipeline, {
    inferencePipeline: (0, _get_pipeline_config.getPipelineConfig)(formState),
    modelType: modelType,
    pipelineName: formState.pipelineName,
    pipelineCreated: formState.pipelineCreated,
    pipelineError: formState.pipelineError,
    sourceIndex: sourceIndex,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    className: "mlTrainedModelsInferencePipelineFlyoutFooter",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 187,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared.AddInferencePipelineFooter, {
    onClose: onClose,
    onCreate: createPipeline,
    step: step,
    setStep: setStep,
    isDetailsStepValid: pipelineNameError === undefined && targetFieldError === undefined,
    isConfigureProcessorStepValid: hasUnsavedChanges === false,
    pipelineCreated: formState.pipelineCreated,
    creatingPipeline: formState.creatingPipeline,
    hasProcessorStep: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 9
    }
  })));
};
exports.AddInferencePipelineFlyout = AddInferencePipelineFlyout;