"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomUrlsDescription = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/application/components/custom_urls/custom_urls_description.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CustomUrlsDescription = exports.CustomUrlsDescription = /*#__PURE__*/(0, _react.memo)(({
  children,
  description
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const styles = {
    describeForm: (0, _react2.css)`
        /* Apply column layout only on screens wider than 768px */
        @media (min-width: 769px) {
          &.euiDescribedFormGroup {
            flex-direction: column;
          }
        }

        /* Widen the Custom URL fields */
        .euiDescribedFormGroup__fieldWrapper,
        .euiDescribedFormGroup__fields {
          max-width: none;
          width: 100%;
        }

        > .euiFlexGroup {
          > .euiFlexItem {
            &:last-child {
              flex-basis: 50%;
            }
          }
        }
      `,
    formRow: (0, _react2.css)`
        margin: 0 ${euiTheme.size.s};
      `
  };
  const title = _i18n.i18n.translate('xpack.ml.public.application.components.customUrls.customUrlsDescription.title', {
    defaultMessage: 'Custom URLs'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    gutterSize: "xs",
    fullWidth: true,
    css: styles.describeForm,
    title: /*#__PURE__*/_react.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 16
      }
    }, title),
    description: description,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    css: styles.formRow,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children)));
});