"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewAlertCondition = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _mlValidators = require("@kbn/ml-validators");
var _util = require("../../application/jobs/new_job/common/job_validator/util");
var _alerts = require("../../../common/constants/alerts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ml/public/alerting/anomaly_detection_rule/preview_alert_condition.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AlertInstancePreview = /*#__PURE__*/_react.default.memo(({
  jobIds,
  timestampIso8601,
  score,
  topInfluencers,
  topRecords
}) => {
  const listItems = [{
    title: _i18n.i18n.translate('xpack.ml.previewAlert.jobsLabel', {
      defaultMessage: 'Job IDs:'
    }),
    description: jobIds.join(', ')
  }, {
    title: _i18n.i18n.translate('xpack.ml.previewAlert.timeLabel', {
      defaultMessage: 'Time: '
    }),
    description: timestampIso8601
  }, {
    title: _i18n.i18n.translate('xpack.ml.previewAlert.scoreLabel', {
      defaultMessage: 'Anomaly score:'
    }),
    description: score
  }, ...(topInfluencers && topInfluencers.length > 0 ? [{
    title: _i18n.i18n.translate('xpack.ml.previewAlert.topInfluencersLabel', {
      defaultMessage: 'Top influencers:'
    }),
    description: /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 17
      }
    }, topInfluencers.map(i => /*#__PURE__*/_react.default.createElement("li", {
      key: i.unique_key,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      transparentBackground: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 23
      }
    }, i.influencer_field_name), " =", ' ', i.influencer_field_value, " [", i.score, "]")))
  }] : []), ...(topRecords && topRecords.length > 0 ? [{
    title: _i18n.i18n.translate('xpack.ml.previewAlert.topRecordsLabel', {
      defaultMessage: 'Top records:'
    }),
    description: /*#__PURE__*/_react.default.createElement("ul", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 17
      }
    }, topRecords.map(i => {
      var _i$typical, _i$actual;
      return /*#__PURE__*/_react.default.createElement("li", {
        key: i.unique_key,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 21
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        transparentBackground: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 23
        }
      }, i.function, "(", i.field_name, ")"), ' ', i.by_field_value, " ", i.over_field_value, " ", i.partition_field_value, " [", i.score, "]; (", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.previewAlert.typicalLabel",
        defaultMessage: "Typical:",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 23
        }
      }), ' ', (_i$typical = i.typical) !== null && _i$typical !== void 0 ? _i$typical : '-', ",", ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.previewAlert.actualLabel",
        defaultMessage: "Actual:",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 23
        }
      }), ' ', (_i$actual = i.actual) !== null && _i$actual !== void 0 ? _i$actual : '-', ")");
    }))
  }] : [])];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: 'row',
    compressed: true,
    listItems: listItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 12
    }
  });
});
const PreviewAlertCondition = ({
  alertingApiService,
  alertParams
}) => {
  var _alertParams$jobSelec, _alertParams$jobSelec2, _alertParams$jobSelec3, _alertParams$jobSelec4;
  const sampleSize = _alerts.ALERT_PREVIEW_SAMPLE_SIZE;
  const [lookBehindInterval, setLookBehindInterval] = (0, _react.useState)();
  const [lastQueryInterval, setLastQueryInterval] = (0, _react.useState)();
  const [areResultsVisible, setAreResultVisible] = (0, _react.useState)(true);
  const [previewError, setPreviewError] = (0, _react.useState)();
  const [previewResponse, setPreviewResponse] = (0, _react.useState)();
  const validators = (0, _react.useMemo)(() => (0, _mlValidators.composeValidators)((0, _mlValidators.requiredValidator)(), (0, _mlValidators.timeIntervalInputValidator)()), []);

  // eslint-disable-next-line react-hooks/exhaustive-deps
  const validationErrors = (0, _react.useMemo)(() => validators(lookBehindInterval), [lookBehindInterval]);
  (0, _react.useEffect)(function resetPreview() {
    setPreviewResponse(undefined);
  }, [alertParams]);
  const testCondition = (0, _react.useCallback)(async () => {
    try {
      const response = await alertingApiService.preview({
        alertParams,
        timeRange: lookBehindInterval,
        sampleSize
      });
      setPreviewResponse(response);
      setLastQueryInterval(lookBehindInterval);
      setPreviewError(undefined);
    } catch (e) {
      var _e$body;
      setPreviewResponse(undefined);
      setPreviewError((_e$body = e.body) !== null && _e$body !== void 0 ? _e$body : e);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [alertParams, lookBehindInterval]);
  const sampleHits = (0, _react.useMemo)(() => {
    if (!previewResponse) return;
    return previewResponse.results;
  }, [previewResponse]);
  const isReady = (((_alertParams$jobSelec = alertParams.jobSelection) === null || _alertParams$jobSelec === void 0 ? void 0 : (_alertParams$jobSelec2 = _alertParams$jobSelec.jobIds) === null || _alertParams$jobSelec2 === void 0 ? void 0 : _alertParams$jobSelec2.length) > 0 || ((_alertParams$jobSelec3 = alertParams.jobSelection) === null || _alertParams$jobSelec3 === void 0 ? void 0 : (_alertParams$jobSelec4 = _alertParams$jobSelec3.groupIds) === null || _alertParams$jobSelec4 === void 0 ? void 0 : _alertParams$jobSelec4.length) > 0) && !!alertParams.resultType && alertParams.severity !== undefined && validationErrors === null;
  const isInvalid = lookBehindInterval !== undefined && !!validationErrors;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: 'flexEnd',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.previewAlert.intervalLabel",
      defaultMessage: "Check the rule condition with an interval",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 15
      }
    }),
    isInvalid: isInvalid,
    error: (0, _util.invalidTimeIntervalMessage)(lookBehindInterval),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    placeholder: "15d, 6m",
    value: lookBehindInterval !== null && lookBehindInterval !== void 0 ? lookBehindInterval : '',
    onChange: e => {
      setLookBehindInterval(e.target.value);
    },
    isInvalid: isInvalid,
    "data-test-subj": 'mlAnomalyAlertPreviewInterval',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: testCondition,
    disabled: !isReady,
    "data-test-subj": 'mlAnomalyAlertPreviewButton',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.previewAlert.testButtonLabel",
    defaultMessage: "Test",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 13
    }
  })))), previewError !== undefined && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.previewAlert.previewErrorTitle",
      defaultMessage: "Unable to load the preview",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 15
      }
    }),
    color: "danger",
    iconType: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 13
    }
  }, previewError.message))), previewResponse && sampleHits && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'xs',
    alignItems: 'center',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    "data-test-subj": 'mlAnomalyAlertPreviewMessage',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 239,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.previewAlert.previewMessage",
    defaultMessage: "Found {alertsCount, plural, one {# anomaly} other {# anomalies}} in the last {interval}.",
    values: {
      alertsCount: previewResponse.count,
      interval: lastQueryInterval
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 240,
      columnNumber: 19
    }
  })))), sampleHits.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: 'primary',
    size: "xs",
    onClick: setAreResultVisible.bind(null, !areResultsVisible),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 17
    }
  }, areResultsVisible ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.previewAlert.hideResultsButtonLabel",
    defaultMessage: "Hide results",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 21
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.previewAlert.showResultsButtonLabel",
    defaultMessage: "Show results",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 264,
      columnNumber: 21
    }
  })))), areResultsVisible && sampleHits.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    borderRadius: "none",
    hasShadow: false,
    "data-test-subj": 'mlAnomalyAlertPreviewCallout',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 275,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 281,
      columnNumber: 15
    }
  }, sampleHits.map((v, i) => {
    return /*#__PURE__*/_react.default.createElement("li", {
      key: v.key,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 284,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(AlertInstancePreview, (0, _extends2.default)({}, v, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 285,
        columnNumber: 23
      }
    })), i !== sampleHits.length - 1 ? /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
      margin: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 286,
        columnNumber: 54
      }
    }) : null);
  })), previewResponse.count > sampleSize ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: 'm',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 293,
      columnNumber: 19
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: 'xs',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 294,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 295,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.previewAlert.otherValuesLabel",
    defaultMessage: "and {count, plural, one {# other} other {# others}}",
    values: {
      count: previewResponse.count - sampleSize
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 23
    }
  })))) : null) : null));
};
exports.PreviewAlertCondition = PreviewAlertCondition;