"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.KeydownScrollZoom = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/keydown_scroll_zoom/keydown_scroll_zoom.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isMac = navigator.platform.toLowerCase().indexOf('mac') >= 0;
class KeydownScrollZoom extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_hideTimeout", void 0);
    (0, _defineProperty2.default)(this, "state", {
      show: false
    });
    (0, _defineProperty2.default)(this, "_onWheel", event => {
      if (this._hideTimeout) {
        clearTimeout(this._hideTimeout);
        this._hideTimeout = undefined;
      }
      if (isMac && event.originalEvent.metaKey || !isMac && event.originalEvent.ctrlKey) {
        this.setState({
          show: false
        });
        return;
      }
      this.setState({
        show: true
      });
      this._hideTimeout = setTimeout(() => {
        if (this._isMounted) {
          this.setState({
            show: false
          });
        }
      }, 1500);
      event.preventDefault();
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this.props.mbMap.on('wheel', this._onWheel);
  }
  componentWillUnmount() {
    this._isMounted = false;
    this.props.mbMap.off('wheel', this._onWheel);
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("aside", {
      className: (0, _classnames.default)('mapKeydownScrollZoom', {
        'mapKeydownScrollZoom--show': this.state.show
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      textAlign: "center",
      size: "s",
      color: "ghost",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("h3", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.maps.keydownScrollZoom.keydownToZoomInstructions', {
      defaultMessage: 'Use {key} + scroll to zoom the map',
      values: {
        key: isMac ? '⌘' : 'control'
      }
    })), /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.maps.keydownScrollZoom.keydownClickAndDragZoomInstructions', {
      defaultMessage: 'Use shift + click and drag to zoom the map to fit within a bounding box'
    }))));
  }
}
exports.KeydownScrollZoom = KeydownScrollZoom;