"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrawControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _mapboxGlDraw = _interopRequireDefault(require("@mapbox/mapbox-gl-draw"));
var _theme = _interopRequireDefault(require("@mapbox/mapbox-gl-draw/src/lib/theme"));
var _mapboxGlDrawRectangleMode = _interopRequireDefault(require("mapbox-gl-draw-rectangle-mode"));
var _constants = require("../../../../common/constants");
var _draw_circle = require("./draw_circle");
var _draw_tooltip = require("./draw_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/mb_map/draw_control/draw_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error
// @ts-expect-error
// @ts-expect-error
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DRAW_RECTANGLE = 'draw_rectangle';
const DRAW_CIRCLE = 'draw_circle';
const mbDrawModes = _mapboxGlDraw.default.modes;
mbDrawModes[DRAW_RECTANGLE] = _mapboxGlDrawRectangleMode.default;
mbDrawModes[DRAW_CIRCLE] = _draw_circle.DrawCircle;
class DrawControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_isMapRemoved", false);
    (0, _defineProperty2.default)(this, "_mbDrawControlAdded", false);
    (0, _defineProperty2.default)(this, "_mbDrawControl", new _mapboxGlDraw.default({
      displayControlsDefault: false,
      modes: mbDrawModes,
      styles: [..._theme.default, _draw_circle.DRAW_CIRCLE_RADIUS_LABEL_STYLE]
    }));
    (0, _defineProperty2.default)(this, "_setIsMapRemoved", () => {
      this._isMapRemoved = true;
    });
    (0, _defineProperty2.default)(this, "_onDraw", event => {
      this.props.onDraw(event, this._mbDrawControl);
    });
    (0, _defineProperty2.default)(this, "_onClick", event => {
      if (this.props.onClick) {
        this.props.onClick(event, this._mbDrawControl);
      }
    });
    // debounce with zero timeout needed to allow mapbox-draw finish logic to complete
    // before _removeDrawControl is called
    (0, _defineProperty2.default)(this, "_syncDrawControl", _lodash.default.debounce(() => {
      if (!this._isMounted) {
        return;
      }
      if (this.props.enable) {
        this._updateDrawControl();
      } else {
        this._removeDrawControl();
      }
    }, 0));
  }
  componentDidUpdate() {
    this._syncDrawControl();
  }
  componentDidMount() {
    this._isMounted = true;
    this.props.mbMap.on('remove', this._setIsMapRemoved);
    this._syncDrawControl();
  }
  componentWillUnmount() {
    this._isMounted = false;
    this.props.mbMap.off('remove', this._setIsMapRemoved);
    this._removeDrawControl();
  }
  _removeDrawControl() {
    // Do not remove draw control after mbMap.remove is called, causes execeptions and mbMap.remove cleans up all map resources.
    if (!this._mbDrawControlAdded || this._isMapRemoved) {
      return;
    }
    this.props.mbMap.getCanvas().style.cursor = '';
    this.props.mbMap.off('draw.create', this._onDraw);
    if (this.props.onClick) {
      this.props.mbMap.off('click', this._onClick);
    }
    this.props.mbMap.removeControl(this._mbDrawControl);
    this._mbDrawControlAdded = false;
  }
  _updateDrawControl() {
    if (!this._mbDrawControlAdded) {
      this.props.mbMap.addControl(this._mbDrawControl);
      this._mbDrawControlAdded = true;
      this.props.mbMap.on('draw.create', this._onDraw);
      if (this.props.onClick) {
        this.props.mbMap.on('click', this._onClick);
      }
    }
    this.props.mbMap.getCanvas().style.cursor = !this.props.drawShape || this.props.drawShape === _constants.DRAW_SHAPE.SIMPLE_SELECT ? '' : 'crosshair';
    const {
      DRAW_LINE_STRING,
      DRAW_POLYGON,
      DRAW_POINT,
      SIMPLE_SELECT
    } = this._mbDrawControl.modes;
    const drawMode = this._mbDrawControl.getMode();
    if (drawMode !== DRAW_RECTANGLE && this.props.drawShape === _constants.DRAW_SHAPE.BOUNDS) {
      this._mbDrawControl.changeMode(DRAW_RECTANGLE);
    } else if (drawMode !== DRAW_CIRCLE && this.props.drawShape === _constants.DRAW_SHAPE.DISTANCE) {
      this._mbDrawControl.changeMode(DRAW_CIRCLE);
    } else if (drawMode !== DRAW_POLYGON && this.props.drawShape === _constants.DRAW_SHAPE.POLYGON) {
      this._mbDrawControl.changeMode(DRAW_POLYGON);
    } else if (drawMode !== DRAW_LINE_STRING && this.props.drawShape === _constants.DRAW_SHAPE.LINE) {
      this._mbDrawControl.changeMode(DRAW_LINE_STRING);
    } else if (drawMode !== DRAW_POINT && this.props.drawShape === _constants.DRAW_SHAPE.POINT) {
      this._mbDrawControl.changeMode(DRAW_POINT);
    } else if (this.props.drawShape === _constants.DRAW_SHAPE.DELETE) {
      this._mbDrawControl.changeMode(SIMPLE_SELECT);
    } else if (this.props.drawShape === _constants.DRAW_SHAPE.WAIT) {
      this.props.mbMap.getCanvas().style.cursor = 'wait';
      this._mbDrawControl.changeMode(SIMPLE_SELECT);
    } else if (drawMode !== SIMPLE_SELECT && !this.props.drawShape || this.props.drawShape === _constants.DRAW_SHAPE.SIMPLE_SELECT) {
      this._mbDrawControl.changeMode(SIMPLE_SELECT);
    }
  }
  render() {
    if (!this.props.drawShape) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_draw_tooltip.DrawTooltip, {
      mbMap: this.props.mbMap,
      drawShape: this.props.drawShape,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 151,
        columnNumber: 12
      }
    });
  }
}
exports.DrawControl = DrawControl;