"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractColorFromStyleProperty = extractColorFromStyleProperty;
var _color_palettes = require("../../../color_palettes");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function extractColorFromStyleProperty(colorStyleProperty, defaultColor) {
  if (!colorStyleProperty) {
    return defaultColor;
  }
  if (colorStyleProperty.type === _constants.STYLE_TYPE.STATIC) {
    return colorStyleProperty.options.color;
  }
  const dynamicOptions = colorStyleProperty.options;

  // Do not use dynamic color unless configuration is complete
  if (!dynamicOptions.field || !dynamicOptions.field.name) {
    return defaultColor;
  }
  if (dynamicOptions.type === _constants.COLOR_MAP_TYPE.CATEGORICAL) {
    if (dynamicOptions.useCustomColorPalette) {
      return dynamicOptions.customColorPalette && dynamicOptions.customColorPalette.length ? dynamicOptions.customColorPalette[0].color : defaultColor;
    }
    if (!dynamicOptions.colorCategory) {
      return defaultColor;
    }
    const palette = (0, _color_palettes.getColorPalette)(dynamicOptions.colorCategory);
    return palette ? palette[0] : defaultColor;
  } else {
    // return middle of gradient for dynamic style property
    if (dynamicOptions.useCustomColorRamp) {
      if (!dynamicOptions.customColorRamp || !dynamicOptions.customColorRamp.length) {
        return defaultColor;
      }
      // favor the lowest color in even arrays
      const middleIndex = Math.floor((dynamicOptions.customColorRamp.length - 1) / 2);
      return dynamicOptions.customColorRamp[middleIndex].color;
    }
    if (!dynamicOptions.color) {
      return defaultColor;
    }
    const centerColor = (0, _color_palettes.getColorRampCenterColor)(dynamicOptions.color);
    return centerColor ? centerColor : defaultColor;
  }
}