"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopHitsForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _single_field_select = require("../../../../components/single_field_select");
var _kibana_services = require("../../../../kibana_services");
var _validated_range = require("../../../../components/validated_range");
var _constants = require("../../../../../common/constants");
var _load_index_settings = require("../util/load_index_settings");
var _group_by_button_group = require("../../es_geo_line_source/geo_line_form/group_by_button_group");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_search_source/top_hits/top_hits_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class TopHitsForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      maxInnerResultWindow: _constants.DEFAULT_MAX_INNER_RESULT_WINDOW
    });
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_onGroupByTimeseriesChange", topHitsGroupByTimeseries => {
      this.props.onChange({
        propName: 'topHitsGroupByTimeseries',
        value: topHitsGroupByTimeseries
      });
    });
    (0, _defineProperty2.default)(this, "_onTopHitsSplitFieldChange", topHitsSplitField => {
      if (!topHitsSplitField) {
        return;
      }
      this.props.onChange({
        propName: 'topHitsSplitField',
        value: topHitsSplitField
      });
    });
    (0, _defineProperty2.default)(this, "_onTopHitsSizeChange", size => {
      this.props.onChange({
        propName: 'topHitsSize',
        value: size
      });
    });
    (0, _defineProperty2.default)(this, "_onSortFieldChange", sortField => {
      this.props.onChange({
        propName: 'sortField',
        value: sortField
      });
    });
    (0, _defineProperty2.default)(this, "_onSortOrderChange", event => {
      this.props.onChange({
        propName: 'sortOrder',
        value: event.target.value
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this.loadIndexSettings();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async loadIndexSettings() {
    try {
      const dataView = await (0, _kibana_services.getIndexPatternService)().get(this.props.indexPatternId);
      const {
        maxInnerResultWindow
      } = await (0, _load_index_settings.loadIndexSettings)(dataView.getIndexPattern());
      if (this._isMounted) {
        this.setState({
          maxInnerResultWindow
        });
      }
    } catch (err) {
      return;
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 7
      }
    }, this.props.isTimeseries && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.esSearch.topHitsGroupByLabel', {
        defaultMessage: 'Group by'
      }),
      display: this.props.isColumnCompressed ? 'columnCompressed' : 'row',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_group_by_button_group.GroupByButtonGroup, {
      groupByTimeseries: this.props.topHitsGroupByTimeseries,
      onGroupByTimeseriesChange: this._onGroupByTimeseriesChange,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 13
      }
    })), !this.props.topHitsGroupByTimeseries && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.esSearch.topHitsSplitFieldLabel', {
        defaultMessage: 'Entity'
      }),
      display: this.props.isColumnCompressed ? 'columnCompressed' : 'row',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
      placeholder: _i18n.i18n.translate('xpack.maps.source.esSearch.topHitsSplitFieldSelectPlaceholder', {
        defaultMessage: 'Select entity field'
      }),
      value: this.props.topHitsSplitField,
      onChange: this._onTopHitsSplitFieldChange,
      fields: this.props.termFields,
      isClearable: false,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 13
      }
    })), (this.props.topHitsSplitField || this.props.topHitsGroupByTimeseries) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: this.props.topHitsGroupByTimeseries ? _i18n.i18n.translate('xpack.maps.source.esSearch.topHitsTimeseriesSizeLabel', {
        defaultMessage: 'Documents per time series'
      }) : _i18n.i18n.translate('xpack.maps.source.esSearch.topHitsSizeLabel', {
        defaultMessage: 'Documents per entity'
      }),
      display: this.props.isColumnCompressed ? 'columnCompressed' : 'row',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_validated_range.ValidatedRange, {
      min: 1,
      max: this.state.maxInnerResultWindow,
      step: 1,
      value: this.props.topHitsSize,
      onChange: this._onTopHitsSizeChange,
      showLabels: true,
      showInput: true,
      showRange: true,
      "data-test-subj": "layerPanelTopHitsSize",
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.esTopHitsSearch.sortFieldLabel', {
        defaultMessage: 'Sort field'
      }),
      display: this.props.isColumnCompressed ? 'columnCompressed' : 'row',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
      placeholder: _i18n.i18n.translate('xpack.maps.source.esSearch.sortFieldSelectPlaceholder', {
        defaultMessage: 'Select sort field'
      }),
      value: this.props.sortField,
      onChange: this._onSortFieldChange,
      fields: this.props.sortFields,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.esTopHitsSearch.sortOrderLabel', {
        defaultMessage: 'Sort order'
      }),
      display: this.props.isColumnCompressed ? 'columnCompressed' : 'row',
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      disabled: !this.props.sortField,
      options: [{
        text: _i18n.i18n.translate('xpack.maps.source.esSearch.ascendingLabel', {
          defaultMessage: 'ascending'
        }),
        value: _public.SortDirection.asc
      }, {
        text: _i18n.i18n.translate('xpack.maps.source.esSearch.descendingLabel', {
          defaultMessage: 'descending'
        }),
        value: _public.SortDirection.desc
      }],
      value: this.props.sortOrder,
      onChange: this._onSortOrderChange,
      compressed: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 182,
        columnNumber: 15
      }
    }))));
  }
}
exports.TopHitsForm = TopHitsForm;