"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryFieldsTable = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var rt = _interopRequireWildcard(require("io-ts"));
var _react = _interopRequireWildcard(require("react"));
var _typed_json = require("../../../../common/typed_json");
var _field_value = require("../log_text_stream/field_value");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/logs_shared/public/components/logging/log_entry_flyout/log_entry_fields_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LogEntryFieldsTable = ({
  logEntry,
  onSetFieldFilter
}) => {
  const createSetFilterHandler = (0, _react.useMemo)(() => onSetFieldFilter ? field => () => {
    if (!rt.array(_typed_json.jsonScalarRT).is(field.value)) {
      return;
    }
    onSetFieldFilter === null || onSetFieldFilter === void 0 ? void 0 : onSetFieldFilter({
      language: 'kuery',
      query: `${escapeKueryLiteral(field.field)}:${field.value.map(escapeKueryLiteral).join(' OR ')}`
    }, logEntry.id, logEntry.cursor);
  } : undefined, [logEntry, onSetFieldFilter]);
  const columns = (0, _react.useMemo)(() => [{
    field: 'field',
    name: _i18n.i18n.translate('xpack.logsShared.logFlyout.fieldColumnLabel', {
      defaultMessage: 'Field'
    }),
    sortable: true
  }, {
    actions: [{
      type: 'icon',
      icon: 'filter',
      name: setFilterButtonLabel,
      description: setFilterButtonDescription,
      available: () => !!createSetFilterHandler,
      onClick: item => createSetFilterHandler === null || createSetFilterHandler === void 0 ? void 0 : createSetFilterHandler(item)()
    }]
  }, {
    field: 'value',
    name: _i18n.i18n.translate('xpack.logsShared.logFlyout.valueColumnLabel', {
      defaultMessage: 'Value'
    }),
    render: (_name, item) => /*#__PURE__*/_react.default.createElement(_field_value.FieldValue, {
      highlightTerms: emptyHighlightTerms,
      isActiveHighlight: false,
      value: item.value,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    })
  }], [createSetFilterHandler]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    columns: columns,
    items: logEntry.fields,
    search: searchOptions,
    sorting: initialSortingOptions,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 5
    }
  });
};
exports.LogEntryFieldsTable = LogEntryFieldsTable;
const emptyHighlightTerms = [];
const initialSortingOptions = {
  sort: {
    field: 'field',
    direction: 'asc'
  }
};
const searchOptions = {
  box: {
    incremental: true,
    schema: true
  }
};
const setFilterButtonLabel = _i18n.i18n.translate('xpack.logsShared.logFlyout.filterAriaLabel', {
  defaultMessage: 'Filter'
});
const setFilterButtonDescription = _i18n.i18n.translate('xpack.logsShared.logFlyout.setFilterTooltip', {
  defaultMessage: 'View event with filter'
});
const escapeKueryLiteral = unquotedLiteral => typeof unquotedLiteral === 'string' ? `"${unquotedLiteral.replace(/"/g, '\\"')}"` : unquotedLiteral;