"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableFeatureBadge = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireWildcard(require("react"));
var _user_messages_utils = require("../../user_messages_utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/lens/public/react_embeddable/user_messages/info_badges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EmbeddableFeatureBadge = ({
  messages
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const xsFontSize = (0, _eui.useEuiFontSize)('xs').fontSize;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(isOpen => !isOpen);
  const closePopover = () => setIsPopoverOpen(false);
  if (!messages.length) {
    return null;
  }
  const iconTitle = _i18n.i18n.translate('xpack.lens.featureBadge.iconDescription', {
    defaultMessage: `{count} visualization {count, plural, one {modifier} other {modifiers}}`,
    values: {
      count: messages.length
    }
  });
  // compact messages be grouping longMessage together on matching unique-id
  const groupedMessages = new Map();
  for (const message of messages) {
    var _groupedMessages$get;
    const group = (_groupedMessages$get = groupedMessages.get(message.uniqueId)) !== null && _groupedMessages$get !== void 0 ? _groupedMessages$get : [];
    group.push(message);
    groupedMessages.set(message.uniqueId, group);
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
      content: iconTitle,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "lns-feature-badges-trigger",
      className: "lnsPanelFeatureList_button",
      color: 'text',
      onClick: onButtonClick,
      title: iconTitle,
      size: "s",
      css: (0, _react.css)`
              color: transparent;
              font-size: ${xsFontSize};
              height: ${euiTheme.size.l} !important;
              padding-inline: ${euiTheme.size.xs};
              .euiButtonEmpty__content {
                gap: ${euiTheme.size.xs};
              }
              &:hover {
                color: ${euiTheme.colors.textParagraph};
              }
              // Make the visualization modifiers icon appear only on panel hover
              .embPanel__content:hover & {
                background: ${euiTheme.colors.backgroundBasePlain};
                transition: color ${euiTheme.animation.slow}, background ${euiTheme.animation.slow};
                color: ${euiTheme.colors.textParagraph};
              }
            `,
      iconType: "wrench",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 51,
        columnNumber: 11
      }
    }, groupedMessages.size)),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          max-width: 280px;
        `,
    "data-test-subj": "lns-feature-badges-panel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }, [...groupedMessages.entries()].map(([uniqueId, messageGroup], index) => {
    const [{
      shortMessage
    }] = messageGroup;
    return /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
      key: uniqueId,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }, index > 0 && /*#__PURE__*/_react2.default.createElement(_eui.EuiHorizontalRule, {
      margin: "none",
      "data-test-subj": "lns-feature-badges-horizontal-rule",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react2.default.createElement("aside", {
      css: (0, _react.css)`
                  padding: ${euiTheme.size.base};
                `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: (0, _react.css)`color=${euiTheme.colors.title}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react2.default.createElement("h3", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 107,
        columnNumber: 19
      }
    }, shortMessage)), /*#__PURE__*/_react2.default.createElement("ul", {
      className: "eui-yScroll",
      css: (0, _react.css)`
                    max-height: 320px;
                  `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 17
      }
    }, messageGroup.map((message, i) => /*#__PURE__*/_react2.default.createElement(_react2.Fragment, {
      key: `${uniqueId}-${i}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 21
      }
    }, (0, _user_messages_utils.getLongMessage)(message))))));
  })));
};
exports.EmbeddableFeatureBadge = EmbeddableFeatureBadge;