"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeIntegrations = initializeIntegrations;
var _esQuery = require("@kbn/es-query");
var _lodash = require("lodash");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _helper = require("../helper");
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function cleanupSerializedState({
  rawState,
  references
}) {
  const cleanedState = (0, _lodash.omit)(rawState, 'searchSessionId');
  return {
    rawState: cleanedState,
    references
  };
}
function initializeIntegrations(getLatestState, serializeDynamicActions, {
  attributeService
}) {
  return {
    api: {
      /**
       * This API is used by the parent to serialize the panel state to save it into its saved object.
       * Make sure to remove the attributes when the panel is by reference.
       */
      serializeState: () => {
        var _serializeDynamicActi;
        const currentState = getLatestState();
        const cleanedState = cleanupSerializedState(attributeService.extractReferences(currentState));
        const {
          rawState: dynamicActionsState,
          references: dynamicActionsReferences
        } = (_serializeDynamicActi = serializeDynamicActions === null || serializeDynamicActions === void 0 ? void 0 : serializeDynamicActions()) !== null && _serializeDynamicActi !== void 0 ? _serializeDynamicActi : {};
        if (cleanedState.rawState.savedObjectId) {
          const {
            savedObjectId,
            attributes,
            ...byRefState
          } = cleanedState.rawState;
          return {
            rawState: {
              ...byRefState,
              ...dynamicActionsState
            },
            references: [...cleanedState.references, ...(dynamicActionsReferences !== null && dynamicActionsReferences !== void 0 ? dynamicActionsReferences : []), {
              name: _presentationPublishing.SAVED_OBJECT_REF_NAME,
              type: _constants.DOC_TYPE,
              id: savedObjectId
            }]
          };
        }
        return {
          rawState: {
            ...cleanedState.rawState,
            ...dynamicActionsState
          },
          references: [...cleanedState.references, ...(dynamicActionsReferences !== null && dynamicActionsReferences !== void 0 ? dynamicActionsReferences : [])]
        };
      },
      // TODO: workout why we have this duplicated
      getFullAttributes: () => getLatestState().attributes,
      getSavedVis: () => getLatestState().attributes,
      isTextBasedLanguage: () => (0, _helper.isTextBasedLanguage)(getLatestState()),
      getTextBasedLanguage: () => {
        var _getLatestState$attri;
        const query = (_getLatestState$attri = getLatestState().attributes) === null || _getLatestState$attri === void 0 ? void 0 : _getLatestState$attri.state.query;
        if (!query || !(0, _esQuery.isOfAggregateQueryType)(query)) {
          return;
        }
        const language = (0, _esQuery.getAggregateQueryMode)(query);
        return (0, _esQuery.getLanguageDisplayName)(language).toUpperCase();
      }
    }
  };
}