"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RangeControl = void 0;
exports.ceilWithPrecision = ceilWithPrecision;
exports.floorWithPrecision = floorWithPrecision;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _form_row = require("./form_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/src/platform/plugins/private/input_control_vis/public/components/vis/range_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function roundWithPrecision(value, decimalPlaces, roundFunction) {
  if (decimalPlaces <= 0) {
    return roundFunction(value);
  }
  let results = value;
  results = results * Math.pow(10, decimalPlaces);
  results = roundFunction(results);
  results = results / Math.pow(10, decimalPlaces);
  return results;
}
function ceilWithPrecision(value, decimalPlaces) {
  return roundWithPrecision(value, decimalPlaces, Math.ceil);
}
function floorWithPrecision(value, decimalPlaces) {
  return roundWithPrecision(value, decimalPlaces, Math.floor);
}
class RangeControl extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {});
    (0, _defineProperty2.default)(this, "onChangeComplete", _lodash.default.debounce(value => {
      const controlValue = {
        min: value[0],
        max: value[1]
      };
      this.props.stageFilter(this.props.controlIndex, controlValue);
    }, 200));
  }
  static getDerivedStateFromProps(nextProps, prevState) {
    const nextValue = nextProps.control.hasValue() ? [nextProps.control.value.min, nextProps.control.value.max] : ['', ''];
    if (nextProps.control.hasValue() && nextProps.control.value.min == null) {
      nextValue[0] = '';
    }
    if (nextProps.control.hasValue() && nextProps.control.value.max == null) {
      nextValue[1] = '';
    }
    if (nextValue !== prevState.prevValue) {
      return {
        value: nextValue,
        prevValue: nextValue
      };
    }
    return null;
  }
  renderControl() {
    if (!this.props.control.isEnabled()) {
      return /*#__PURE__*/_react.default.createElement(_public.ValidatedDualRange, {
        disabled: true,
        showInput: true,
        min: 0,
        max: 100,
        value: ['', ''],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 14
        }
      });
    }
    const decimalPlaces = _lodash.default.get(this.props, 'control.options.decimalPlaces', 0);
    const min = floorWithPrecision(this.props.control.min, decimalPlaces);
    const max = ceilWithPrecision(this.props.control.max, decimalPlaces);
    const ticks = [{
      value: min,
      label: min
    }, {
      value: max,
      label: max
    }];
    return /*#__PURE__*/_react.default.createElement(_public.ValidatedDualRange, {
      id: this.props.control.id,
      min: min,
      max: max,
      value: this.state.value,
      onChange: this.onChangeComplete,
      showInput: true,
      showRange: true,
      showTicks: true,
      ticks: ticks,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_form_row.FormRow, {
      id: this.props.control.id,
      label: this.props.control.label,
      controlIndex: this.props.controlIndex,
      disableMsg: this.props.control.isEnabled() ? undefined : this.props.control.disabledReason,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 7
      }
    }, this.renderControl());
  }
}
exports.RangeControl = RangeControl;