"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Gsub = void 0;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _field_components = require("../field_components");
var _shared = require("./shared");
var _field_name_field = require("./common_fields/field_name_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _target_field = require("./common_fields/target_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/gsub.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  emptyField
} = _shared_imports.fieldValidators;
const fieldsConfig = {
  /* Required fields config */
  pattern: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.gsubForm.patternFieldLabel', {
      defaultMessage: 'Pattern'
    }),
    deserializer: (0, _lodash.flow)(String, _shared.to.escapeBackslashes),
    serializer: _shared.from.unescapeBackslashes,
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.gsubForm.patternFieldHelpText', {
      defaultMessage: 'Regular expression used to match substrings in the field.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.gsubForm.patternRequiredError', {
        defaultMessage: 'A value is required.'
      }), false)
    }, {
      validator: _shared.isJSONStringValidator
    }]
  },
  // This is a required field, but we exclude validation because we accept empty values as ''
  replacement: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.gsubForm.replacementFieldLabel', {
      defaultMessage: 'Replacement'
    }),
    deserializer: (0, _lodash.flow)(String, _shared.to.escapeBackslashes),
    serializer: _shared.from.unescapeBackslashes,
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.gsubForm.replacementFieldHelpText', {
      defaultMessage: 'Replacement text for matches. A blank value will remove the matched text from the resulting text.'
    })
  }
};
const Gsub = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.gsubForm.fieldNameHelpText', {
      defaultMessage: 'Field to search for matches.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.pattern,
    component: _field_components.TextEditor,
    componentProps: {
      editorProps: {
        height: _shared.EDITOR_PX_HEIGHT.extraSmall,
        options: {
          minimap: {
            enabled: false
          }
        }
      }
    },
    path: "fields.pattern",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.replacement,
    component: _shared_imports.Field,
    path: "fields.replacement",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }));
};
exports.Gsub = Gsub;