"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Custom = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _field_components = require("../field_components");
var _shared = require("./shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/custom.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  emptyField
} = _shared_imports.fieldValidators;
const customConfig = {
  type: _shared_imports.FIELD_TYPES.TEXT,
  label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.customForm.optionsFieldLabel', {
    defaultMessage: 'Configuration'
  }),
  serializer: _shared.from.optionalXJson,
  deserializer: value => {
    return _shared.to.xJsonString(value.customOptions ? value.customOptions : value);
  },
  validations: [{
    validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.customForm.configurationRequiredError', {
      defaultMessage: 'Configuration is required.'
    }))
  }, {
    validator: (0, _shared.isXJsonField)(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.customForm.invalidJsonError', {
      defaultMessage: 'The input is not valid.'
    }))
  }]
};
/**
 * This is a catch-all component to support settings for custom processors
 * or existing processors not yet supported by the UI.
 *
 * We store the settings in a field called "customOptions"
 **/
const Custom = ({
  defaultOptions
}) => {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "customOptions",
    component: _field_components.XJsonEditor,
    config: customConfig,
    defaultValue: defaultOptions,
    componentProps: {
      editorProps: {
        'data-test-subj': 'processorOptionsEditor',
        height: _shared.EDITOR_PX_HEIGHT.large,
        'aria-label': _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.customForm.optionsFieldAriaLabel', {
          defaultMessage: 'Configuration JSON editor'
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  });
};
exports.Custom = Custom;