"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContextMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n_texts = require("./i18n_texts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/pipeline_processors_editor_item/context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getStyles = ({
  hidden
}) => ({
  container: hidden ? (0, _react2.css)`
        display: none;
      ` : undefined
});
const ContextMenu = exports.ContextMenu = /*#__PURE__*/(0, _react.forwardRef)((props, ref) => {
  const {
    showAddOnFailure,
    onDuplicate,
    onAddOnFailure,
    onDelete,
    disabled,
    hidden
  } = props;
  const styles = getStyles({
    hidden
  });
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const contextMenuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "duplicateButton",
    key: "duplicate",
    icon: "copy",
    onClick: () => {
      setIsOpen(false);
      onDuplicate();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, _i18n_texts.i18nTexts.duplicateButtonLabel), showAddOnFailure ? /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "addOnFailureButton",
    key: "addOnFailure",
    icon: "indexClose",
    onClick: () => {
      setIsOpen(false);
      onAddOnFailure();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 7
    }
  }, _i18n_texts.i18nTexts.addOnFailureButtonLabel) : undefined, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    "data-test-subj": "deleteButton",
    key: "delete",
    icon: "trash",
    color: "danger",
    onClick: () => {
      setIsOpen(false);
      onDelete();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 5
    }
  }, _i18n_texts.i18nTexts.deleteButtonLabel)].filter(Boolean);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.container,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": props['data-test-subj'],
    anchorPosition: "leftCenter",
    panelPaddingSize: "none",
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      buttonRef: ref,
      "data-test-subj": "button",
      disabled: disabled,
      onClick: () => setIsOpen(v => !v),
      iconType: "boxesHorizontal",
      "aria-label": _i18n_texts.i18nTexts.moreButtonAriaLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: contextMenuItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  })));
});