"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initGetLogEntryCategoryExamplesRoute = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _http_api = require("../../../../common/http_api");
var _log_analysis = require("../../../lib/log_analysis");
var _errors = require("../../../lib/log_analysis/errors");
var _request_context = require("../../../utils/request_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initGetLogEntryCategoryExamplesRoute = ({
  framework,
  getStartServices
}) => {
  framework.registerVersionedRoute({
    access: 'internal',
    method: 'post',
    path: _http_api.logAnalysisResultsV1.LOG_ANALYSIS_GET_LOG_ENTRY_CATEGORY_EXAMPLES_PATH
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _ioTsUtils.createRouteValidationFunction)(_http_api.logAnalysisResultsV1.getLogEntryCategoryExamplesRequestPayloadRT)
      }
    }
  }, framework.router.handleLegacyErrors(async (requestContext, request, response) => {
    const {
      data: {
        categoryId,
        exampleCount,
        logView,
        idFormat,
        timeRange: {
          startTime,
          endTime
        }
      }
    } = request.body;
    const [, {
      logsShared
    }] = await getStartServices();
    const resolvedLogView = await logsShared.logViews.getScopedClient(request).getResolvedLogView(logView);
    try {
      const infraMlContext = await (0, _request_context.assertHasInfraMlPlugins)(requestContext);
      const {
        data: logEntryCategoryExamples,
        timing
      } = await (0, _log_analysis.getLogEntryCategoryExamples)({
        infra: await infraMlContext.infra,
        core: await infraMlContext.core
      }, logView, idFormat, startTime, endTime, categoryId, exampleCount, resolvedLogView);
      return response.ok({
        body: _http_api.logAnalysisResultsV1.getLogEntryCategoryExamplesSuccessReponsePayloadRT.encode({
          data: {
            examples: logEntryCategoryExamples
          },
          timing
        })
      });
    } catch (error) {
      var _error$statusCode, _error$message;
      if (_boom.default.isBoom(error)) {
        throw error;
      }
      if ((0, _errors.isMlPrivilegesError)(error)) {
        return response.customError({
          statusCode: 403,
          body: {
            message: error.message
          }
        });
      }
      return response.customError({
        statusCode: (_error$statusCode = error.statusCode) !== null && _error$statusCode !== void 0 ? _error$statusCode : 500,
        body: {
          message: (_error$message = error.message) !== null && _error$message !== void 0 ? _error$message : 'An unexpected error occurred'
        }
      });
    }
  }));
};
exports.initGetLogEntryCategoryExamplesRoute = initGetLogEntryCategoryExamplesRoute;