"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateInputFieldNotEmpty = exports.validateInputFieldHasNotEmptySpaces = exports.validateInputFieldHasNotEmptyEntries = exports.createInputRangeFieldProps = exports.createInputFieldProps = exports.aggregateValidationErrors = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/settings/input_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const createInputFieldProps = ({
  errors,
  name,
  onChange,
  value
}) => ({
  error: errors,
  isInvalid: errors.length > 0,
  name,
  onChange: evt => onChange(evt.currentTarget.value),
  value
});
exports.createInputFieldProps = createInputFieldProps;
const createInputRangeFieldProps = ({
  errors,
  name,
  onChange,
  value
}) => ({
  error: errors,
  isInvalid: errors.length > 0,
  name,
  onChange: (evt, isValid) => onChange(+evt.currentTarget.value, isValid),
  value
});
exports.createInputRangeFieldProps = createInputRangeFieldProps;
const aggregateValidationErrors = (...validationHandlers) => value => validationHandlers.map(validator => validator(value)).filter(Boolean);
exports.aggregateValidationErrors = aggregateValidationErrors;
const isEmptyString = value => value === '';
const containsSpaces = value => value.includes(' ');
const containsEmptyEntries = value => value.split(',').some(isEmptyString);
const validateInputFieldNotEmpty = value => isEmptyString(value) && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.sourceConfiguration.fieldEmptyErrorMessage",
  defaultMessage: "The field must not be empty.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 112,
    columnNumber: 5
  }
});
exports.validateInputFieldNotEmpty = validateInputFieldNotEmpty;
const validateInputFieldHasNotEmptyEntries = value => containsEmptyEntries(value) && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.sourceConfiguration.fieldContainEmptyEntryErrorMessage",
  defaultMessage: "The field must not include empty comma-separated values.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 120,
    columnNumber: 5
  }
});
exports.validateInputFieldHasNotEmptyEntries = validateInputFieldHasNotEmptyEntries;
const validateInputFieldHasNotEmptySpaces = value => containsSpaces(value) && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.sourceConfiguration.fieldContainSpacesErrorMessage",
  defaultMessage: "The field must not include spaces.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 128,
    columnNumber: 5
  }
});
exports.validateInputFieldHasNotEmptySpaces = validateInputFieldHasNotEmptySpaces;