"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AwsSQSLayout = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _chart_section_vis = require("../chart_section_vis");
var _section = require("../section");
var _sub_section = require("../sub_section");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/metric_detail/components/layouts/aws_sqs_layout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AwsSQSLayout = exports.AwsSQSLayout = (0, _eui.withEuiTheme)(({
  metrics,
  onChangeRangeTime,
  theme
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 18,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(_section.Section, {
  navLabel: "AWS SQS",
  sectionLabel: _i18n.i18n.translate('xpack.infra.metricDetailPage.sqsMetricsLayout.overviewSection.sectionLabel', {
    defaultMessage: 'Aws SQS Overview'
  }),
  metrics: metrics,
  onChangeRangeTime: onChangeRangeTime,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 19,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsSQSMessagesVisible",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.sqsMetricsLayout.messagesVisible.sectionLabel', {
    defaultMessage: 'Messages Available'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 30,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "abbreviatedNumber",
  seriesOverrides: {
    visible: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.sqsMetricsLayout.messagesVisible.chartLabel', {
        defaultMessage: 'Available'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsSQSMessagesDelayed",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.sqsMetricsLayout.messagesDelayed.sectionLabel', {
    defaultMessage: 'Messages Delayed'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 53,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "abbreviatedNumber",
  seriesOverrides: {
    delayed: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.sqsMetricsLayout.messagesDelayed.chartLabel', {
        defaultMessage: 'Delayed'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 62,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsSQSMessagesSent",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.sqsMetricsLayout.messagesSent.sectionLabel', {
    defaultMessage: 'Messages Added'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 76,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "abbreviatedNumber",
  seriesOverrides: {
    sent: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.sqsMetricsLayout.messagesSent.chartLabel', {
        defaultMessage: 'Added'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 85,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsSQSMessagesEmpty",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.sqsMetricsLayout.messagesEmpty.sectionLabel', {
    defaultMessage: 'Messages Empty'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 99,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "abbreviatedNumber",
  seriesOverrides: {
    sent: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.sqsMetricsLayout.messagesEmpty.chartLabel', {
        defaultMessage: 'Empty'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 108,
    columnNumber: 11
  }
})), /*#__PURE__*/_react.default.createElement(_sub_section.SubSection, {
  id: "awsSQSOldestMessage",
  label: _i18n.i18n.translate('xpack.infra.metricDetailPage.sqsMetricsLayout.oldestMessage.sectionLabel', {
    defaultMessage: 'Oldest Message'
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 122,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_chart_section_vis.ChartSectionVis, {
  type: "bar",
  formatter: "abbreviatedNumber",
  seriesOverrides: {
    oldest: {
      color: theme.euiTheme.colors.vis.euiColorVis1,
      name: _i18n.i18n.translate('xpack.infra.metricDetailPage.sqsMetricsLayout.oldestMessage.chartLabel', {
        defaultMessage: 'Age'
      })
    }
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 131,
    columnNumber: 11
  }
})))));