"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PalettePreview = void 0;
var _react = _interopRequireDefault(require("react"));
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _get_color_palette = require("../../lib/get_color_palette");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/solutions/observability/plugins/infra/public/pages/metrics/inventory_view/components/waffle/palette_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const PalettePreview = ({
  steps,
  palette,
  reverse
}) => {
  const colors = (0, _get_color_palette.getColorPalette)(palette, steps, reverse);
  return /*#__PURE__*/_react.default.createElement(Swatches, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 22,
      columnNumber: 5
    }
  }, colors.map(color => /*#__PURE__*/_react.default.createElement(Swatch, {
    key: color,
    style: {
      backgroundColor: color
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 24,
      columnNumber: 9
    }
  })));
};
exports.PalettePreview = PalettePreview;
const Swatch = _styled.default.div`
  max-width: 15px;
  height: 12px;
  flex: 1 1 auto;
  &:first-child {
    border-radius: ${props => props.theme.euiTheme.border.radius} 0 0 ${props => props.theme.euiTheme.border.radius};
  }
  &:last-child {
    border-radius: 0 ${props => props.theme.euiTheme.border.radius} ${props => props.theme.euiTheme.border.radius} 0;
`;
const Swatches = _styled.default.div`
  display: flex;
`;