"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexActionsContextMenu = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _convert_to_lookup_index_modal_container = require("../details_page/convert_to_lookup_index_modal/convert_to_lookup_index_modal_container");
var _flatten_panel_tree = require("../../../../lib/flatten_panel_tree");
var _constants = require("../../../../../../common/constants");
var _routing = require("../../../../services/routing");
var _notification = require("../../../../services/notification");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/index_list/index_actions_context_menu/index_actions_context_menu.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class IndexActionsContextMenu extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "closeConfirmModal", () => {
      this.setState({
        renderConfirmModal: null
      });
      this.props.resetSelection && this.props.resetSelection();
    });
    (0, _defineProperty2.default)(this, "confirmAction", isActionConfirmed => {
      this.setState({
        isActionConfirmed
      });
    });
    (0, _defineProperty2.default)(this, "onButtonClick", () => {
      this.setState(prevState => ({
        isPopoverOpen: !prevState.isPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "closePopoverAndExecute", func => {
      this.setState({
        isPopoverOpen: false,
        renderConfirmModal: false
      });
      func();
      this.props.resetSelection && this.props.resetSelection();
    });
    (0, _defineProperty2.default)(this, "closePopover", () => {
      this.setState({
        isPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "forcemergeSegmentsError", () => {
      const {
        forcemergeSegments
      } = this.state;
      if (!forcemergeSegments || forcemergeSegments.match(/^([1-9][0-9]*)?$/)) {
        return;
      } else {
        return _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.segmentsNumberErrorMessage', {
          defaultMessage: 'The number of segments must be greater than zero.'
        });
      }
    });
    (0, _defineProperty2.default)(this, "renderForcemergeSegmentsModal", () => {
      const {
        forcemergeIndices,
        indexNames
      } = this.props;
      const helpText = _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.forceMergeSegmentsHelpText', {
        defaultMessage: 'Merge the segments in an index until the number is reduced to this or fewer segments. The default is 1.'
      });
      const selectedIndexCount = indexNames.length;
      const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
      return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        "aria-labelledby": confirmModalTitleId,
        title: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.confirmModal.modalTitle', {
          defaultMessage: 'Force merge'
        }),
        titleProps: {
          id: confirmModalTitleId
        },
        onCancel: this.closeConfirmModal,
        onConfirm: () => {
          if (!this.forcemergeSegmentsError()) {
            this.closePopoverAndExecute(() => {
              forcemergeIndices(this.state.forcemergeSegments);
              this.setState({
                forcemergeSegments: null,
                showForcemergeSegmentsModal: null
              });
            });
          }
        },
        cancelButtonText: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.confirmModal.cancelButtonText', {
          defaultMessage: 'Cancel'
        }),
        confirmButtonText: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.confirmModal.confirmButtonText', {
          defaultMessage: 'Force merge'
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 353,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 384,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexActionsMenu.forceMerge.forceMergeDescription",
        defaultMessage: "You are about to force merge {selectedIndexCount, plural, one {this index} other {these indices} }:",
        values: {
          selectedIndexCount
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 385,
          columnNumber: 11
        }
      })), /*#__PURE__*/_react.default.createElement("ul", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 392,
          columnNumber: 9
        }
      }, indexNames.map(indexName => /*#__PURE__*/_react.default.createElement("li", {
        key: indexName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 394,
          columnNumber: 13
        }
      }, indexName))), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.proceedWithCautionCallOutTitle', {
          defaultMessage: 'Proceed with caution!'
        }),
        color: "warning",
        iconType: "question",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 398,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 408,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexActionsMenu.forceMerge.forceMergeWarningDescription",
        defaultMessage: " Don't force-merge indices to which you're still writing, or to which you'll write again in the future. Instead, rely on the automatic background merge process to perform merges as needed to keep the index running smoothly. If you write to a force-merged index then its performance may become much worse. ",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 409,
          columnNumber: 13
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 421,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
        isInvalid: !!this.forcemergeSegmentsError(),
        error: this.forcemergeSegmentsError(),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 423,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMerge.maximumNumberOfSegmentsFormRowLabel', {
          defaultMessage: 'Maximum number of segments per shard'
        }),
        helpText: helpText,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 427,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
        "data-test-subj": "indexActionsForcemergeNumSegments",
        onChange: event => {
          this.setState({
            forcemergeSegments: event.target.value
          });
        },
        min: 1,
        name: "maxNumberSegments",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 436,
          columnNumber: 13
        }
      }))));
    });
    (0, _defineProperty2.default)(this, "renderConfirmDeleteModal", () => {
      const {
        deleteIndices,
        indexNames
      } = this.props;
      const selectedIndexCount = indexNames.length;
      const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
      const standardIndexModalBody = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 456,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 457,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexActionsMenu.deleteIndex.deleteDescription",
        defaultMessage: "You are about to delete {selectedIndexCount, plural, one {this index} other {these indices} }:",
        values: {
          selectedIndexCount
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 458,
          columnNumber: 11
        }
      })), /*#__PURE__*/_react.default.createElement("ul", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 465,
          columnNumber: 9
        }
      }, indexNames.map(indexName => /*#__PURE__*/_react.default.createElement("li", {
        key: indexName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 467,
          columnNumber: 13
        }
      }, indexName))), /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 471,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.indexActionsMenu.deleteIndex.deleteWarningDescription",
        defaultMessage: "You can't recover a deleted index. Make sure you have appropriate backups. Deleting an index currently being reindexed will stop the reindex operation.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 472,
          columnNumber: 11
        }
      })));
      return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        "aria-labelledby": confirmModalTitleId,
        title: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.deleteIndex.confirmModal.modalTitle', {
          defaultMessage: 'Delete {selectedIndexCount, plural, one {index} other {# indices} }',
          values: {
            selectedIndexCount
          }
        }),
        titleProps: {
          id: confirmModalTitleId
        },
        onCancel: () => {
          this.confirmAction(false);
          this.closeConfirmModal();
        },
        onConfirm: () => this.closePopoverAndExecute(deleteIndices),
        buttonColor: "danger",
        confirmButtonDisabled: false,
        cancelButtonText: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.deleteIndex.confirmModal.cancelButtonText', {
          defaultMessage: 'Cancel'
        }),
        confirmButtonText: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.deleteIndex.confirmModal.confirmButtonText', {
          defaultMessage: 'Delete {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 481,
          columnNumber: 7
        }
      }, standardIndexModalBody);
    });
    (0, _defineProperty2.default)(this, "renderConvertToLookupIndexModal", () => {
      const {
        services: {
          extensionsService
        },
        core: {
          application,
          http
        }
      } = this.context;
      const {
        indexNames,
        indicesListURLParams
      } = this.props;
      const sourceIndexName = indexNames[0];
      return /*#__PURE__*/_react.default.createElement(_convert_to_lookup_index_modal_container.ConvertToLookupIndexModalContainer, {
        onCloseModal: () => this.closeConfirmModal(),
        onSuccess: lookupIndexName => {
          (0, _routing.navigateToIndexDetailsPage)(lookupIndexName, indicesListURLParams, extensionsService, application, http, _constants.IndexDetailsSection.Overview);
          _notification.notificationService.showSuccessToast(_i18n.i18n.translate('xpack.idxMgmt.convertToLookupIndexAction.indexConvertedToastTitle', {
            defaultMessage: 'Index successfully converted to lookup mode'
          }), _i18n.i18n.translate('xpack.idxMgmt.convertToLookupIndexAction.indexConvertedToastMessage', {
            defaultMessage: 'The {lookupIndexName} lookup index has been created.',
            values: {
              lookupIndexName
            }
          }));
        },
        sourceIndexName: sourceIndexName,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 527,
          columnNumber: 7
        }
      });
    });
    (0, _defineProperty2.default)(this, "isConvertableToLookupIndex", indexName => {
      const index = this.props.indices.find(index => index.name === indexName);
      if (!index) {
        return false;
      }
      if ((index === null || index === void 0 ? void 0 : index.documents) >= 0 && (index === null || index === void 0 ? void 0 : index.documents) <= _constants.MAX_DOCUMENTS_FOR_CONVERT_TO_LOOKUP_INDEX && Number(index === null || index === void 0 ? void 0 : index.primary) === _constants.MAX_SHARDS_FOR_CONVERT_TO_LOOKUP_INDEX) {
        return true;
      }
      return false;
    });
    this.state = {
      isPopoverOpen: false,
      renderConfirmModal: null,
      isActionConfirmed: false
    };
  }
  panels() {
    const {
      services: {
        extensionsService
      },
      core: {
        getUrlForApp,
        application,
        http
      },
      history,
      config: {
        enableIndexActions
      }
    } = this.context;
    const {
      closeIndices,
      openIndices,
      flushIndices,
      refreshIndices,
      clearCacheIndices,
      isOnListView,
      indexNames,
      indexStatusByName,
      performExtensionAction,
      indices,
      reloadIndices,
      indicesListURLParams
    } = this.props;
    const allOpen = (0, _lodash.every)(indexNames, indexName => {
      return indexStatusByName[indexName] === _constants.INDEX_OPEN;
    });
    const selectedIndexCount = indexNames.length;
    const items = [];
    if (isOnListView && selectedIndexCount === 1) {
      items.push({
        'data-test-subj': 'showOverviewIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.showIndexOverviewLabel', {
          defaultMessage: 'Show index overview'
        }),
        onClick: () => {
          (0, _routing.navigateToIndexDetailsPage)(indexNames[0], indicesListURLParams, extensionsService, application, http, _constants.IndexDetailsSection.Overview);
        }
      });
      items.push({
        'data-test-subj': 'showSettingsIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.showIndexSettingsLabel', {
          defaultMessage: 'Show index settings'
        }),
        onClick: () => {
          (0, _routing.navigateToIndexDetailsPage)(indexNames[0], indicesListURLParams, extensionsService, application, http, _constants.IndexDetailsSection.Settings);
        }
      });
      items.push({
        'data-test-subj': 'showMappingsIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.showIndexMappingLabel', {
          defaultMessage: 'Show index mapping'
        }),
        onClick: () => {
          (0, _routing.navigateToIndexDetailsPage)(indexNames[0], indicesListURLParams, extensionsService, application, http, _constants.IndexDetailsSection.Mappings);
        }
      });
      if (allOpen && enableIndexActions) {
        items.push({
          'data-test-subj': 'showStatsIndexMenuButton',
          name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.showIndexStatsLabel', {
            defaultMessage: 'Show index stats'
          }),
          onClick: () => {
            history.push((0, _routing.getIndexDetailsLink)(indexNames[0], indicesListURLParams, _constants.IndexDetailsSection.Stats));
          }
        });
      }
    }
    if (allOpen && enableIndexActions) {
      items.push({
        'data-test-subj': 'closeIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.closeIndexLabel', {
          defaultMessage: 'Close {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          this.closePopoverAndExecute(closeIndices);
        }
      });
      items.push({
        'data-test-subj': 'forcemergeIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.forceMergeIndexLabel', {
          defaultMessage: 'Force merge {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          this.closePopover();
          this.setState({
            renderConfirmModal: this.renderForcemergeSegmentsModal
          });
        }
      });
      items.push({
        'data-test-subj': 'refreshIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.refreshIndexLabel', {
          defaultMessage: 'Refresh {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          this.closePopoverAndExecute(refreshIndices);
        }
      });
      items.push({
        'data-test-subj': 'clearCacheIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.clearIndexCacheLabel', {
          defaultMessage: 'Clear {selectedIndexCount, plural, one {index} other {indices} } cache',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          this.closePopoverAndExecute(clearCacheIndices);
        }
      });
      items.push({
        'data-test-subj': 'flushIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.flushIndexLabel', {
          defaultMessage: 'Flush {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          this.closePopoverAndExecute(flushIndices);
        }
      });
    } else if (!allOpen && enableIndexActions) {
      items.push({
        'data-test-subj': 'openIndexMenuButton',
        name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.openIndexLabel', {
          defaultMessage: 'Open {selectedIndexCount, plural, one {index} other {indices} }',
          values: {
            selectedIndexCount
          }
        }),
        onClick: () => {
          this.closePopoverAndExecute(openIndices);
        }
      });
    }
    items.push({
      'data-test-subj': 'deleteIndexMenuButton',
      name: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.deleteIndexLabel', {
        defaultMessage: 'Delete {selectedIndexCount, plural, one {index} other {indices} }',
        values: {
          selectedIndexCount
        }
      }),
      onClick: () => {
        this.closePopover();
        this.setState({
          renderConfirmModal: this.renderConfirmDeleteModal
        });
      }
    });
    extensionsService.actions.forEach(actionExtension => {
      const actionExtensionDefinition = actionExtension({
        indices,
        reloadIndices,
        getUrlForApp
      });
      if (actionExtensionDefinition) {
        const {
          buttonLabel,
          requestMethod,
          successMessage,
          renderConfirmModal
        } = actionExtensionDefinition;
        if (requestMethod) {
          items.push({
            name: buttonLabel,
            onClick: () => {
              this.closePopoverAndExecute(async () => {
                await performExtensionAction(requestMethod, successMessage);
              });
            }
          });
        } else {
          items.push({
            name: buttonLabel,
            onClick: () => {
              this.closePopover();
              this.setState({
                renderConfirmModal
              });
            }
          });
        }
      }
    });
    if (selectedIndexCount === 1) {
      const indexName = indexNames[0];
      const isConvertable = this.isConvertableToLookupIndex(indexName);
      const index = indices.find(index => index.name === indexName);
      const {
        plugins: {
          reindexService
        }
      } = this.context;

      // Only show the "Convert to lookup index" action if the reindexService plugin is available,
      // the index is not already a lookup index and the index is not hidden
      if (reindexService && (index === null || index === void 0 ? void 0 : index.mode) !== 'lookup' && !(index !== null && index !== void 0 && index.hidden)) {
        items.push({
          'data-test-subj': 'convertToLookupIndexButton',
          name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 271,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.idxMgmt.indexActionsMenu.convertToLookupIndexButton",
            defaultMessage: "Convert to lookup index",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 272,
              columnNumber: 17
            }
          })), !isConvertable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
            size: "xs",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 279,
              columnNumber: 19
            }
          }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "xs",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 280,
              columnNumber: 19
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.idxMgmt.indexActionsMenu.convertToLookupIndexButton.error",
            defaultMessage: "The index must have less than 2 billion documents and a single shard to be converted.",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 281,
              columnNumber: 21
            }
          })))),
          disabled: !isConvertable,
          onClick: () => {
            this.closePopover();
            this.setState({
              renderConfirmModal: this.renderConvertToLookupIndexModal
            });
          }
        });
      }
    }
    const panelTree = {
      id: 0,
      title: _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.panelTitle', {
        defaultMessage: '{selectedIndexCount, plural, one {Index} other {Indices} } options',
        values: {
          selectedIndexCount
        }
      }),
      items
    };
    return (0, _flatten_panel_tree.flattenPanelTree)(panelTree);
  }
  render() {
    const {
      indexNames
    } = this.props;
    const selectedIndexCount = indexNames.length;
    const {
      iconSide = 'right',
      anchorPosition = 'rightUp',
      label = _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.manageButtonLabel', {
        defaultMessage: 'Manage {selectedIndexCount, plural, one {index} other {{selectedIndexCount} indices}}',
        values: {
          selectedIndexCount
        }
      }),
      iconType = 'arrowDown',
      fill = true,
      isLoading = false
    } = this.props;
    const panels = this.panels();
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "indexActionsContextMenuButton",
      iconSide: iconSide,
      "aria-label": _i18n.i18n.translate('xpack.idxMgmt.indexActionsMenu.manageButtonAriaLabel', {
        defaultMessage: 'Manage {selectedIndexCount, plural, one {index} other {{selectedIndexCount} indices}}',
        values: {
          selectedIndexCount
        }
      }),
      onClick: this.onButtonClick,
      iconType: iconType,
      fill: fill,
      isLoading: isLoading,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 591,
        columnNumber: 7
      }
    }, label);
    return /*#__PURE__*/_react.default.createElement("div", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 609,
        columnNumber: 7
      }
    }, this.state.renderConfirmModal ? this.state.renderConfirmModal(this.closeConfirmModal) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "contextMenuIndices",
      button: button,
      isOpen: this.state.isPopoverOpen,
      closePopover: this.closePopover,
      panelPaddingSize: "none",
      anchorPosition: anchorPosition,
      repositionOnScroll: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 613,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      "data-test-subj": "indexContextMenu",
      initialPanelId: 0,
      panels: panels,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 622,
        columnNumber: 11
      }
    })));
  }
}
exports.IndexActionsContextMenu = IndexActionsContextMenu;
(0, _defineProperty2.default)(IndexActionsContextMenu, "contextType", _app_context.AppContext);