"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeletePolicyModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _api = require("../../../../services/api");
var _app_context = require("../../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764234682703327195/elastic/kibana-artifacts-staging/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/enrich_policies_list/confirm_modals/delete_policy_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeletePolicyModal = ({
  policyToDelete,
  callback
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  const mounted = (0, _react.useRef)(false);
  const {
    services: {
      notificationService
    }
  } = (0, _app_context.useAppContext)();
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);

  // Since the async action of this component needs to set state after unmounting,
  // we need to track the mounted state of this component to avoid a memory leak.
  (0, _react.useEffect)(() => {
    mounted.current = true;
    return () => {
      mounted.current = false;
    };
  }, []);
  const handleDeletePolicy = () => {
    setIsDeleting(true);
    (0, _api.deleteEnrichPolicy)(policyToDelete).then(({
      data,
      error
    }) => {
      if (data) {
        const successMessage = _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.deleteModal.successDeleteNotificationMessage', {
          defaultMessage: 'Deleted {policyToDelete}',
          values: {
            policyToDelete
          }
        });
        notificationService.showSuccessToast(successMessage);
        return callback({
          hasDeletedPolicy: true
        });
      }
      if (error) {
        const errorMessage = _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.deleteModal.errorDeleteNotificationMessage', {
          defaultMessage: "Error deleting enrich policy: ''{error}''",
          values: {
            error: error.message
          }
        });
        notificationService.showDangerToast(errorMessage);
      }
      callback();
    }).finally(() => {
      if (mounted.current) {
        setIsDeleting(false);
      }
    });
  };
  const handleOnCancel = () => {
    callback();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    titleProps: {
      id: confirmModalTitleId
    },
    buttonColor: "danger",
    "data-test-subj": "deletePolicyModal",
    title: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.deleteModal.confirmTitle', {
      defaultMessage: 'Delete enrich policy'
    }),
    onCancel: handleOnCancel,
    onConfirm: handleDeletePolicy,
    cancelButtonText: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.deleteModal.cancelButton', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicies.deleteModal.deleteButton', {
      defaultMessage: 'Delete'
    }),
    confirmButtonDisabled: isDeleting,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicies.deleteModal.bodyCopy",
    defaultMessage: "You are about to delete the enrich policy {policy}. This action is irreversible.",
    values: {
      policy: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 101,
          columnNumber: 21
        }
      }, policyToDelete)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  })));
};
exports.DeletePolicyModal = DeletePolicyModal;